import os
from yozuch import logger, config
from yozuch.generators import content_generator, TemplatePageGenerator, TemplateWriter
from yozuch.entries import TemplateSiteEntry
from yozuch.utils import glob2, format_url_from_object


@content_generator('pages')
class PageGenerator(TemplatePageGenerator):

    def load(self, context, url_template, project_dir, source='*.*', id=None, **kwargs):
        content_dir = os.path.join(project_dir, 'pages')
        if os.path.isdir(content_dir):
            for path in glob2(content_dir, source):
                filename = os.path.basename(path)
                name, ext = os.path.splitext(filename)
                if ext in config.PAGE_FILE_EXTENSIONS:
                    entry = TemplateSiteEntry('!pages/' + filename, slug=name, filename=filename)
                    entry.url = format_url_from_object(url_template, entry)
                    yield entry, None, TemplateWriter(id)
        else:
            logger.warning("'page' route is specified but pages directory is not exists")