import copy
import collections
from yozuch import logger
from yozuch.generators import TemplatePageGenerator, TemplateEntryWriter
from yozuch.utils import format_url_from_object


class PostItemCollectionGenerator(TemplatePageGenerator):

    def __init__(self, collection_name, post_item_name, item_name):
        super(PostItemCollectionGenerator, self).__init__()
        self._collection_name = collection_name
        self._post_item_name = post_item_name
        self._item_name = item_name

    def _get_items(self, posts, url_template):
        items = {}
        for post in posts:
            coll = getattr(post, self._post_item_name)
            if coll is not None:
                if not isinstance(coll, collections.Iterable):
                    coll = (coll,)
                for item in coll:
                    item.url = format_url_from_object(url_template, item)
                    if item.name not in items:
                        items[item.name] = copy.copy(item)
                        items[item.name].posts = []
                    items[item.name].posts.append(post)
        result = sorted(items.values(), key=lambda t: t.name)
        return sorted(result, key=lambda t: len(t.posts), reverse=True)

    def generate(self, context, url_template, project_dir, template=None, id=None, **kwargs):
        if 'posts' in context['site']:
            items = self._get_items(context['site']['posts'], url_template)
            logger.info('Found {} {}'.format(len(items), self._collection_name))
            context['site'][self._collection_name] = items
            for item in items:
                item.template = template
                yield item, None, TemplateEntryWriter(id, self._item_name)
