"""
Site models.
"""

from yozuch.utils import normalize_slug


def linkitems(objs, reverse=False):
    previtem = None
    if reverse:
        objs = reversed(objs)
    for obj in objs:
        obj.previtem = previtem
        if previtem is not None:
            previtem.nextitem = obj
        previtem = obj
    return objs


class LinkedListItemMixin(object):
    nextitem = None
    previtem = None


class SiteEntry(LinkedListItemMixin):

    _slug = None

    @property
    def slug(self):
        return self._slug

    @slug.setter
    def slug(self, val):
        self._slug = normalize_slug(val)

    source_path = None
    id = None
    url = None


class TemplateSiteEntry(SiteEntry):

    template = None
    filename = None

    def __init__(self, template=None, url=None, slug=None, filename=None):
        self.template = template
        self.url = url
        self.filename = filename
        if slug is not None:
            self.slug = slug


class AssetSiteEntry(SiteEntry):

    def __init__(self, source_path, url=None):
        self.source_path = source_path
        self.url = url


class CollectionItem(TemplateSiteEntry):

    _name = None

    def __init__(self, name):
        super(CollectionItem, self).__init__()
        self.name = name
        self.posts = []

    @property
    def name(self):
        return self._name

    @name.setter
    def name(self, name):
        self._name = name
        self.slug = name

    def __str__(self):
        return self.slug


class Document(TemplateSiteEntry):

    def __init__(self):
        super(Document, self).__init__()
        self._metadata = {}
        self._slug = None

    @property
    def metadata(self):
        return self._metadata

    @metadata.setter
    def metadata(self, fields):
        self._metadata.update(fields)
        for key in fields:
            if key in ('author', 'date', 'slug'):
                setattr(self, key, fields[key])

    author = None
    date = None
    title = None
    content = None
    summary = None


class RSTDocument(Document):

    def __init__(self, doctree, source_path):
        super(RSTDocument, self).__init__()
        self.doctree = doctree
        self.source_path = source_path