import os
import shutil
import fnmatch
from yozuch.utils import makedirs, path_from_url
from yozuch.ttt import iteritems
from yozuch.generators import ContentGeneratorBase, WriterBase
from yozuch.entries import AssetSiteEntry


def fnmatch_patterns(name, patterns):
    return any([fnmatch.fnmatch(name, pattern) for pattern in patterns])


class AssetGenerator(ContentGeneratorBase):

    DEFAULT_IGNORE_PATTERNS = ['.DS_Store']

    class AssetWriter(WriterBase):

        def write(self, entry, context, env, output_dir):
            path = os.path.join(output_dir, path_from_url(entry.url))
            makedirs(os.path.dirname(path))
            shutil.copyfile(entry.source_path, path)

    def generate(self, context, url_template, ignore=DEFAULT_IGNORE_PATTERNS, **kwargs):
        assets = context['collections'].get('assets', {})
        for source_path, relpath in iteritems(assets):
            if ignore is None or (not fnmatch_patterns(os.path.basename(source_path), ignore) and not fnmatch_patterns(relpath, ignore)):
                url = url_template.format(filename=relpath)
                yield AssetSiteEntry(source_path, url), None, self.AssetWriter()
