import os
from yozuch.generators import TemplatePageGenerator, TemplateWriter
from yozuch.entries import TemplateSiteEntry
from yozuch.utils import format_url_from_object


class PageGenerator(TemplatePageGenerator):

    def generate(self, context, url_template, source='*.*', **kwargs):
        pages = context['collections'].get('pages', [])
        for filename in pages:
            name, ext = os.path.splitext(filename)
            entry = TemplateSiteEntry('!pages/' + filename, slug=name, filename=filename)
            entry.url = format_url_from_object(url_template, entry)
            yield entry, None, TemplateWriter('pages/{}'.format(filename))