import os
from yozuch import logger
from yozuch.loaders import LoaderBase


class AssetLoader(LoaderBase):

    def load(self, context, directory='assets', **kwargs):
        source_dir = os.path.join(context['project_dir'], directory)
        if os.path.isdir(source_dir):
            assets = context['collections']['assets'] = context['collections'].get('assets', {})
            logger.info('Processing assets directory {}...'.format(source_dir))
            for root, _, files in os.walk(source_dir):
                for filename in files:
                    source_path = os.path.join(root, filename)
                    assets[source_path] = os.path.relpath(source_path, source_dir)