from yozuch.route import route

DEBUG = True

RST_OPTIONS = {
    'add_heading_permalink': True,
}

THEME_NAME = 'test'
THEME_CONFIG = {
    'foo': 'bar'
}

ROUTES = (
    route('/', 'blog-index'),
    route('/paginated_index.html', 'blog-index', posts_per_page=1, pagination_url='/page/{number}/',
          template='blog_index.html'),
    route('/blog/{date:%Y}/{date:%m}/{date:%d}/{slug}/', 'posts'),
    route('/tags/', 'tags-index'),
    route('/tag/{slug}/', 'tags'),
    route('/categories/', 'categories-index'),
    route('/category/{slug}/', 'categories'),
    route('/archive/', 'archive-index'),
    route('/atom.xml', 'atom-feed'),
    route('/{filename}', 'assets'),
    route('/url1.html', 'documents', template='template1.html', source='/documents/page.rst'),
    route('/documents/{slug}/', 'documents', template='document.html', source='/documents/page2.rst'),
    route('/documents/{slug}/', 'documents', template='document.html', source='/documents/page3.rst'),
    route('/{filename}', 'pages'),
)

FOO = 'bar'