import os
from yozuch.loaders.rstloader import RstLoader
from tests import YozuchTestCase

ROOT_DIR = os.path.dirname(__file__)


class LoaderTest(YozuchTestCase):

    def setUp(self):
        super(LoaderTest, self).setUp()
        self.loader = RstLoader(self.config['RST_OPTIONS'])

    def test_posts(self):
        posts = self.loader.load_documents(os.path.join(ROOT_DIR, 'data', 'posts'))
        self.assertEqual(len(posts), 2)
        self.assertEqual(len(self.logger_handler.messages['error']), 1)

    def test_posts_subdirectory_as_category(self):
        posts = self.loader.load_documents(os.path.join(ROOT_DIR, 'data', 'posts'), subdirectory_as_category=True)
        self.assertEqual(len(posts), 3)
        self.assertEqual(len(self.logger_handler.messages['error']), 1)

    def test_posts_empty(self):
        posts = self.loader.load_documents(os.path.join(ROOT_DIR, 'data'))
        self.assertEqual(len(posts), 0)
        self.assertFalse(self._is_logger_errors())

    def test_document(self):
        docs = self.loader.load_documents(os.path.join(ROOT_DIR, 'data', 'documents'))
        self.assertEqual(len(docs), 3)
        self.assertFalse(self._is_logger_errors())