from yozuch.generators import TemplatePageGenerator, TemplateWriter
from yozuch.entries import TemplateSiteEntry
from yozuch.paginator import Paginator


class BlogIndexGenerator(TemplatePageGenerator):

    class BlogIndexWriter(TemplateWriter):

        def __init__(self, page_id, paginator=None, paginator_page=None):
            super(BlogIndexGenerator.BlogIndexWriter, self).__init__(page_id)
            self._paginator = paginator
            self._paginator_page = paginator_page

        def write(self, entry, context, env, output_dir):
            if self._paginator is None:
                self._write_page(entry, env, context, output_dir)
            else:
                template_vars = {
                    'paginator': self._paginator,
                    'paginator_page': self._paginator_page
                }
                self._write_page(entry, env, context, output_dir, template_vars)

    def generate(self, context, url_template, template=None, posts_per_page=None, pagination_url=None, name=None, **kwargs):
        if 'posts' in context['site'] and posts_per_page is not None and pagination_url is not None and posts_per_page > 0:
            paginator = Paginator(context['site']['posts'], posts_per_page)
            for page in paginator.pages:
                if page.number == 1:
                    page.url = url_template
                    yield TemplateSiteEntry(template, url_template), None, self.BlogIndexWriter(name, paginator, page)
                else:
                    page.url = pagination_url.format(number=page.number)
                    page_id = '{}/{}'.format(name, page.number)
                    yield TemplateSiteEntry(template, page.url), None, self.BlogIndexWriter(page_id, paginator, page)
        else:
            yield TemplateSiteEntry(template, url_template), None, self.BlogIndexWriter(name)