from yozuch.generators import TemplatePageGenerator, TemplateEntryWriter, PublisherBase
from yozuch.utils import format_url_from_object
from yozuch.rstparser import RstParser


class RSTDocumentPublisher(PublisherBase):

    def _publish_document(self, entry, context):
        config = context['config']
        rst_options = config['RST_OPTIONS']
        parser = RstParser(rst_options)
        rooturl = config['URL'] if not config['DEBUG'] else None
        permalink_text = rst_options['permalink_text'] if rst_options['add_heading_permalink'] else None
        parser.publish(entry, context.get('references', None), rooturl, permalink_text)

    def publish(self, entry, context):
        self._publish_document(entry, context)


class DocumentGenerator(TemplatePageGenerator):

    def _generate_document(self, context, url_template, template, entry):
        entry.url = format_url_from_object(url_template, entry)
        entry.template = template
        self._register_document_reference(context, entry)
        return entry, RSTDocumentPublisher(), TemplateEntryWriter(entry.id, 'document')

    def generate(self, context, url_template, source=None, template=None, **kwargs):
        docs = context['collections'].get('documents', {})
        if source is not None:
            yield self._generate_document(context, url_template, template, docs[source])
        else:
            for doc in docs.values():
                yield self._generate_document(context, url_template, template, doc)