from yozuch.generators import TemplatePageGenerator, TemplateEntryWriter
from yozuch.generators.document import RSTDocumentPublisher
from yozuch.utils import format_url_from_object


class PostGenerator(TemplatePageGenerator):

    def generate(self, context, url_template, template=None, **kwargs):
        if 'posts' in context['site']:
            posts = context['site']['posts']
            for post in posts:
                post.url = format_url_from_object(url_template, post)
                post.template = template
                self._register_document_reference(context, post)
                yield post, RSTDocumentPublisher(), TemplateEntryWriter(post.id, 'post')