from yozuch import logger
from yozuch.generators import TemplatePageGenerator, TemplateEntryWriter
from yozuch.utils import format_url_from_object


class PostItemCollectionGenerator(TemplatePageGenerator):

    def __init__(self, collection_name, meta_name, template_item_name):
        super(PostItemCollectionGenerator, self).__init__()
        self._collection_name = collection_name
        self._post_item_name = meta_name
        self._item_name = template_item_name

    def generate(self, context, url_template, template=None, name=None, **kwargs):
        if 'posts' in context['site']:
            items = context['site'][self._collection_name]
            logger.info('Found {} {}'.format(len(items), self._collection_name))
            for item in items:
                item.template = template
                item.url = format_url_from_object(url_template, item)
                page_id = '{}/{}'.format(name, item.slug)
                yield item, None, TemplateEntryWriter(page_id, self._item_name)