import os
from yozuch.utils import import_module_member


class LoaderManager(object):

    def load(self, context):
        for name, kwargs in context['config']['LOADERS']:
            cls = import_module_member(name)
            if cls is not None:
                loader = cls()
                loader.load(context, **kwargs)
            else:
                raise LookupError('Unable to find generator with name "{}"'.format(name))


class LoaderBase(object):

    def load(self, context, **kwargs):
        raise NotImplementedError()


class RSTDocumentLoader(LoaderBase):

    def _id_from_path(self, project_dir, source_path):
        return '/' + os.path.relpath(source_path, project_dir).replace('\\', '/')