import os
from yozuch import logger
from yozuch.loaders import RSTDocumentLoader
from yozuch.loaders.rstloader import RstLoader


class DocumentLoader(RSTDocumentLoader):

    def load(self, context, **kwargs):
        docs_dir = os.path.join(context['project_dir'], 'documents')
        if os.path.isdir(docs_dir):
            loader = RstLoader(context['config']['RST_OPTIONS'])
            context['collections']['documents'] = context['collections'].get('documents', {})
            docs = loader.load_documents(docs_dir)
            for doc in docs:
                doc.id = self._id_from_path(context['project_dir'], doc.source_path)
                context['collections']['documents'][doc.id] = doc
            logger.info('Loaded {} documents'.format(len(docs)))