import os
from yozuch.loaders import LoaderBase


class PageLoader(LoaderBase):

    def load(self, context, **kwargs):
        pages_dir = os.path.join(context['project_dir'], 'pages')
        if os.path.isdir(pages_dir):
            pages = context['collections']['pages'] = context['collections'].get('pages', [])
            for filename in os.listdir(pages_dir):
                path = os.path.join(pages_dir, filename)
                if os.path.isfile(path):
                    filename = os.path.basename(path)
                    name, ext = os.path.splitext(filename)
                    if ext in context['config']['PAGE_FILE_EXTENSIONS']:
                        pages.append(filename)