import os
from yozuch import logger
from yozuch.entries import linkitems, CollectionItem
from yozuch.loaders import RSTDocumentLoader
from yozuch.loaders.rstloader import RstLoader


class PostLoader(RSTDocumentLoader):

    def _create_post_meta_collection(self, post, site_collection, meta_items):
        if not isinstance(meta_items, list):
            meta_items = [meta_items]
        for name in meta_items:
            if name not in site_collection:
                site_collection[name] = CollectionItem(name)
            site_collection[name].posts.append(post)
            yield site_collection[name]

    def _create_meta_collection(self, posts, site_collection, meta_name):
        for post in posts:
            meta_items = post.metadata.get(meta_name, [])
            items = list(self._create_post_meta_collection(post, site_collection, meta_items))
            setattr(post, meta_name, items)
        result = sorted(site_collection.values(), key=lambda t: t.name)
        return sorted(result, key=lambda t: len(t.posts), reverse=True)

    def _create_meta_collections(self, context, posts):
        context['collections']['tags'] = {}
        context['site']['tags'] = self._create_meta_collection(posts, context['collections']['tags'], 'tags')

        context['collections']['categories'] = {}
        context['site']['categories'] = self._create_meta_collection(posts, context['collections']['categories'], 'category')

    def load(self, context, default_category=None, subdirectory_as_category=True, **kwargs):
        posts_path = os.path.join(context['project_dir'], 'posts')
        if os.path.isdir(posts_path):
            loader = RstLoader(context['config']['RST_OPTIONS'])

            posts = loader.load_documents(posts_path, default_category=default_category,
                                          subdirectory_as_category=subdirectory_as_category)
            posts = sorted(posts, key=lambda p: p.date)
            linkitems(posts)
            posts = list(reversed(posts))
            for post in posts:
                post.id = self._id_from_path(context['project_dir'], post.source_path)

            self._create_meta_collections(context, posts)
            context['site']['posts'] = posts

            logger.info('Loaded {} posts'.format(len(posts)))