"""
Preview server.
"""

import os
import traceback
from threading import Thread
from yozuch import logger
from yozuch.watcher import watch
from yozuch.ttt import SimpleHTTPServer
from yozuch.ttt import SocketServer
from yozuch.notification_server import WebSocketNotificationServer
from yozuch.cache import CACHE_DIR_NAME


class HTTPServer(SocketServer.TCPServer):
    allow_reuse_address = True


def serve(directory, build_command, ports):

    output_dir = os.path.join(CACHE_DIR_NAME, 'output')
    os.chdir(build_command(output_dir))

    autoreload_server = WebSocketNotificationServer()

    def cmd():
        try:
            build_command(output_dir)
            autoreload_server.broadcast_message('reload')
        except:
            traceback.print_exc()

    stop_watcher = watch(directory, cmd)

    http_server_port, autoreload_server_port = ports

    handler = SimpleHTTPServer.SimpleHTTPRequestHandler
    httpd = HTTPServer(('', http_server_port), handler)

    autoreload_server_thread = Thread(target=autoreload_server.start, args=(autoreload_server_port,))
    autoreload_server_thread.start()

    logger.info('Serving content at port {}'.format(http_server_port))
    logger.info('Auto reload server at port {}'.format(autoreload_server_port))
    logger.info('Press "Ctrl+C" to exit')

    try:
        httpd.serve_forever()
    except KeyboardInterrupt:
        stop_watcher()
        logger.info('Shutting down server...')
        autoreload_server.stop()
        httpd.socket.close()
        autoreload_server_thread.join()