################################################################################
# ZMSMetacmdProvider.py
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
################################################################################


# Imports.
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Products.PageTemplates import ZopePageTemplate
from Products.PythonScripts import PythonScript
import copy
import urllib
import zope.interface
# Product Imports.
import _globals
import IZMSMetacmdProvider,IZMSConfigurationProvider
import ZMSItem


# Example code.
# -------------

dtmlExampleCode = '<!-- @deprecated -->'

pageTemplateExampleCode = \
  '<!DOCTYPE html>\n' + \
  '<html lang="en">\n' + \
  '<tal:block tal:content="structure python:here.zmi_html_head(here,request)">zmi_html_head</tal:block>\n' + \
  '<body class="zmi">\n' + \
  '<tal:block tal:content="structure python:here.zmi_body_header(here,request,options=here.customize_manage_options())">zmi_body_header</tal:block>\n' + \
  '<div id="zmi-tab">\n' + \
  '<tal:block tal:content="structure python:here.zmi_breadcrumbs(here,request)">zmi_breadcrumbs</tal:block>\n' + \
  '<div style="clear:both;">&nbsp;</div>\n' + \
  '</div><!-- #zmi-tab -->\n' + \
  '<script>\n' + \
  '</script>\n' + \
  '<tal:block tal:content="structure python:here.zmi_body_footer(here,request)">zmi_body_footer</tal:block>\n' + \
  '</body>\n' + \
  '</html>\n'

pyScriptExampleCode = \
  '# Example code:\n' + \
  '\n' + \
  '# Import a standard function, and get the HTML request and response objects.\n' + \
  'from Products.PythonScripts.standard import html_quote\n' + \
  'request = container.REQUEST\n' + \
  'RESPONSE =  request.RESPONSE\n' + \
  '\n' + \
  '# Return a string identifying this script.\n' + \
  'print "This is the", script.meta_type, \'"%s"\' % script.getId(),\n' + \
  'if script.title:\n' + \
  '    print "(%s)" % html_quote(script.title),\n' + \
  'print "in", container.absolute_url()\n' + \
  'return printed\n' + \
  ''


################################################################################
################################################################################
###
###   Class
###
################################################################################
################################################################################
class ZMSMetacmdProvider(
        ZMSItem.ZMSItem):
    zope.interface.implements(
        IZMSConfigurationProvider.IZMSConfigurationProvider,
        IZMSMetacmdProvider.IZMSMetacmdProvider)

    # Properties.
    # -----------
    meta_type = 'ZMSMetacmdProvider'
    icon = "misc_/zms/ZMSMetacmdProvider.png"

    # Management Options.
    # -------------------
    manage_options_default_action = '../manage_customize'
    def manage_options(self):
      return map( lambda x: self.operator_setitem( x, 'action', '../'+x['action']), copy.deepcopy(self.aq_parent.manage_options()))

    def manage_sub_options(self):
      return (
        {'label': 'TAB_METACMD','action': 'manage_main'},
        )

    # Management Interface.
    # ---------------------
    manage = PageTemplateFile('zpt/ZMSMetacmdProvider/manage_main',globals()) 
    manage_main = PageTemplateFile('zpt/ZMSMetacmdProvider/manage_main',globals()) 
    manage_main_acquire = PageTemplateFile('zpt/ZMSMetacmdProvider/manage_main_acquire',globals()) 

    # Management Permissions.
    # -----------------------
    __administratorPermissions__ = (
		'manage_changeProperties', 'manage_main', 'manage_main_acquire'
		)
    __ac_permissions__=(
		('ZMS Administrator', __administratorPermissions__),
		)

    ############################################################################
    #  ZMSMetacmdProvider.__init__: 
    #
    #  Constructor.
    ############################################################################
    def __init__(self, commands=[]):
      self.id = 'metacmd_manager'
      self.commands = copy.deepcopy(commands)

    """
    ################################################################################
    #
    #   X M L   I M / E X P O R T
    #
    ################################################################################
    """
    
    # ------------------------------------------------------------------------------
    #  ZMSMetacmdProvider.importXml
    # ------------------------------------------------------------------------------
    
    def _importXml(self, item, createIfNotExists=1):
    
      id = item['id']
      if createIfNotExists == 1:
    
        # Delete existing object.
        try: self.delMetacmd(id)
        except: pass
    
        # Initialize attributes of new object.
        newId = id
        newAcquired = 0
        newName = item['name']
        newTitle = item.get('title','')
        newMethod = item['meta_type']
        newExec = item.has_key('exec') and item['exec']
        newDescription = item.get('description','')
        newIconClazz = item.get('icon_clazz','')
        newMetaTypes = item['meta_types']
        newRoles = item['roles']
        newNodes = item.get('nodes','{$}')
        newData = item['data']
    
        # Return with new id.
        return self.setMetacmd(None, newId, newAcquired, newName, newTitle, newMethod, \
          newData, newExec, newDescription, newIconClazz, newMetaTypes, newRoles, \
          newNodes)


    def importXml(self, xml, REQUEST=None, createIfNotExists=1):
      v = self.parseXmlString(xml)
      if type(v) is list:
        for item in v:
          id = self._importXml(item,createIfNotExists)
      else:
        id = self._importXml(v,createIfNotExists)


    # ------------------------------------------------------------------------------
    #  ZMSMetacmdProvider.delMetacmd:
    # 
    #  Delete Action specified by given Id.
    # ------------------------------------------------------------------------------
    def delMetacmd(self, id):
      
      # Catalog.
      obs = self.commands
      old = filter(lambda x: x['id']==id, obs)
      if len(old) > 0:
        obs.remove(old[0])
      self.commands = obs
      # Make persistent.
      self.commands = copy.deepcopy(self.commands)
      
      # Remove Template.
      home = self.aq_parent
      home.manage_delObjects(ids=[id])
      
      # Return with empty id.
      return ''

    # ------------------------------------------------------------------------------
    #  ZMSMetacmdProvider.setMetacmd:
    #
    #  Set/add Action specified by given Id.
    # ------------------------------------------------------------------------------
    def setMetacmd(self, id, newId, newAcquired, newName='', newTitle='', newMethod=None, \
          newData=None, newExec=0, newDescription='', newIconClazz='', newMetaTypes=[], \
          newRoles=['ZMSAdministrator'], newNodes='{$}'):
      
      # Catalog.
      obs = self.commands
      old = filter(lambda x: x['id'] in [id, newId], obs)
      if len(old) > 0:
        obs.remove(old[0])
      
      # Values.
      new = {}
      new['id'] = newId
      new['acquired'] = newAcquired
      new['name'] = newName
      new['title'] = newTitle
      new['description'] = newDescription
      new['icon_clazz'] = newIconClazz
      new['meta_types'] = newMetaTypes
      new['roles'] = newRoles
      new['nodes'] = newNodes
      new['exec'] = newExec
      obs.append(new)
      # Make persistent.
      self.commands = copy.deepcopy(self.commands)
      
      # Insert Template.
      home = self.aq_parent
      if id is None:
        newTitle = '*** DO NOT DELETE OR MODIFY ***'
        if newAcquired:
          home = self.getPortalMaster()
          newMethod = getattr(home,newId).meta_type
        if newId in self.objectIds():
          home.manage_delObjects(ids=[newId])
        if newMethod == 'DTML Method': 
          home.manage_addDTMLMethod(newId,newTitle) 
          if newData is None: 
            newData = dtmlExampleCode
        elif newMethod == 'DTML Document': 
          home.manage_addDTMLDocument(newId,newTitle) 
          if newData is None:
            newData = dtmlExampleCode 
        elif newMethod == 'Page Template':
          ZopePageTemplate.manage_addPageTemplate(home,id=newId,title=newTitle)
          if newData is None: 
            newData = pageTemplateExampleCode 
        elif newMethod == 'Script (Python)':
          PythonScript.manage_addPythonScript(home,newId)
          if newData is None:
            newData = pyScriptExampleCode
      
      # Rename Template.
      elif id != newId:
        home.manage_renameObject(id=id,new_id=newId)
      
      # Update Template.
      ob = getattr(home,newId,None)
      if ob is not None:
        if newAcquired:
          newData = ''
        if newData is not None:
          if ob.meta_type in ['DTML Method','DTML Document']:
            ob.manage_edit(title=ob.title,data=newData)
          elif ob.meta_type == 'Page Template':
            ob.pt_edit(newData,content_type=ob.content_type)
          elif ob.meta_type == 'Script (Python)':
            ob.write(newData)
      
      # Return with new id.
      return newId


    # --------------------------------------------------------------------------
    #  ZMSMetacmdProvider.getMetaCmdDescription
    # --------------------------------------------------------------------------
    def getMetaCmdDescription(self, id=None, name=None):
      """
      Returns description of meta-command specified by ID.
      """
      return self.getMetaCmd(id,name).get('description','')


    # --------------------------------------------------------------------------
    #  ZMSMetacmdProvider.getMetaCmd
    # 
    # Returns action.
    # --------------------------------------------------------------------------
    def getMetaCmd(self, id=None, name=None):
      obs = []
      for x in self.commands:
        # Acquire from parent.
        if x.get('acquired',0)==1:
          portalMaster = self.getPortalMaster()
          if portalMaster is not None:
            x = portalMaster.getMetaCmd(x['id']) 
            x['acquired'] = 1
        else:
          x = x.copy()
        obs.append(x)
      # Filter by Id.
      if id is not None:
        obs = filter(lambda x: x['id']==id, obs)
      # Filter by Name.
      if name is not None:
        obs = filter(lambda x: x['name']==name, obs)
      # Not found!
      if len(obs) == 0:
        return None
      ob = obs[0]
      ob['meta_type'] = getattr(self,ob['id']).meta_type
      return ob


    # --------------------------------------------------------------------------
    #  ZMSMetacmdProvider.getMetaCmdIds
    #
    #  Returns list of action-ids.
    # --------------------------------------------------------------------------
    def getMetaCmdIds(self, sort=1):
      obs = self.commands
      if sort:
        obs = map(lambda x: self.getMetaCmd(x['id']), obs)
        obs = filter( lambda x: x is not None, obs)
        obs = map(lambda x: (x['name'],x), obs)
        obs.sort()
        obs = map(lambda x: x[1], obs)
      ids = map(lambda x: x['id'], obs)
      return ids


    # --------------------------------------------------------------------------
    #  ZMSMetacmdProvider.getMetaCmds
    #
    #  Returns list of actions.
    # --------------------------------------------------------------------------
    def getMetaCmds(self, sort=True):
      metaCmds = []
      portalMasterMetaCmds = None
      for metaCmd in self.commands:
        # Acquire from parent.
        if metaCmd.get('acquired',0)==1:
          if portalMasterMetaCmds is None:
            portalMaster = self.getPortalMaster()
            portalMasterMetaCmds = portalMaster.getMetaCmds()
          l = filter(lambda x: x['id']==metaCmd['id'], portalMasterMetaCmds)
          if len(l) > 0:
            metaCmd = l[0]
            metaCmd['acquired'] = 1
        else:
          metaCmd = metaCmd.copy()
          metaCmd['home'] = self
        metaCmds.append(metaCmd)
      return metaCmds


    ############################################################################
    #  ZMSMetacmdProvider.manage_changeMetacmds:
    #
    #  Change Meta-Commands.
    ############################################################################
    def manage_changeMetacmds(self, btn, lang, REQUEST, RESPONSE):
        """ ZMSMetacmdProvider.manage_changeMetacmds """
        message = ''
        id = REQUEST.get('id','')
        
        # Acquire.
        # --------
        if btn == self.getZMILangStr('BTN_ACQUIRE'):
          aq_ids = REQUEST.get('aq_ids',[])
          for newId in aq_ids:
            newAcquired = 1
            self.setMetacmd(None, newId, newAcquired)
          message = self.getZMILangStr('MSG_INSERTED')%str(len(aq_ids))
        
        # Change.
        # -------
        elif btn == self.getZMILangStr('BTN_SAVE'):
          id = REQUEST['id']
          newId = REQUEST['el_id']
          newAcquired = 0
          newName = REQUEST.get('el_name','').strip()
          newTitle = REQUEST.get('el_title','').strip()
          newMethod = None
          newData = REQUEST.get('el_data','').strip()
          newExec = REQUEST.get('el_exec',0)
          newDescription = REQUEST.get('el_description','').strip()
          newIconClazz = REQUEST.get('el_icon_clazz','')
          newMetaTypes = REQUEST.get('el_meta_types',[])
          newRoles = REQUEST.get('el_roles',[])
          newNodes = REQUEST.get('el_nodes','')
          id = self.setMetacmd(id, newId, newAcquired, newName, newTitle, \
            newMethod, newData, newExec, newDescription, newIconClazz, \
            newMetaTypes, newRoles, newNodes)
          message = self.getZMILangStr('MSG_CHANGED')
        
        # Copy.
        # -----
        elif btn == self.getZMILangStr('BTN_COPY'):
          metaOb = self.getMetaCmd(id)
          if metaOb.get('acquired',0) == 1:
            portalMaster = self.getPortalMaster()
            if portalMaster is not None:
              REQUEST.set('ids',[id])
              xml =  portalMaster.manage_changeMetacmds(self.getZMILangStr('BTN_EXPORT'), lang, REQUEST, RESPONSE)
              self.importXml(xml=xml)
              message = self.getZMILangStr('MSG_IMPORTED')%('<i>%s</i>'%id)
        
        # Delete.
        # -------
        elif btn == self.getZMILangStr('BTN_DELETE'):
          if id:
            ids = [id]
          else:
            ids = REQUEST.get('ids',[])
          for id in ids:
            self.delMetacmd(id)
          id = ''
          message = self.getZMILangStr('MSG_DELETED')%len(ids)
        
        # Export.
        # -------
        elif btn == self.getZMILangStr('BTN_EXPORT'):
          value = []
          ids = REQUEST.get('ids',[])
          for metaCmd in self.getMetaCmds():
            if metaCmd['id'] in ids or len(ids) == 0:
              # Catalog.
              el_id = metaCmd['id']
              el_name = metaCmd['name']
              el_title = metaCmd.get('title','')
              el_description = metaCmd['description']
              el_icon_clazz = metaCmd.get('icon_clazz','')
              el_meta_types = metaCmd['meta_types']
              el_roles = metaCmd['roles']
              el_exec = metaCmd['exec']
              # Object.
              ob = getattr(self,metaCmd['id'])
              el_meta_type = ob.meta_type
              if ob.meta_type in ['DTML Method','DTML Document']:
                el_data = ob.raw
              elif ob.meta_type in ['Page Template']:
                el_data = ob.read()
              elif ob.meta_type in ['Script (Python)']:
                el_data = ob.body()
              # Value.
              value.append({'id':el_id,'name':el_name,'title':el_title,'description':el_description,'meta_types':el_meta_types,'roles':el_roles,'exec':el_exec,'icon_clazz':el_icon_clazz,'meta_type':el_meta_type,'data':el_data})
          # XML.
          if len(value)==1:
            value = value[0]
            filename = '%s.metacmd.xml'%value['id']
          else:
            filename = 'export.metacmd.xml'
          content_type = 'text/xml; charset=utf-8'
          export = self.getXmlHeader() + self.toXmlString(value,1)
          
          RESPONSE.setHeader('Content-Type',content_type)
          RESPONSE.setHeader('Content-Disposition','attachment;filename="%s"'%filename)
          return export
        
        # Import.
        # -------
        elif btn == self.getZMILangStr('BTN_IMPORT'):
          f = REQUEST['file']
          if f:
            filename = f.filename
            self.importXml(xml=f)
          else:
            filename = REQUEST['init']
            createIfNotExists = 1
            self.importConf(filename, REQUEST, createIfNotExists)
          message = self.getZMILangStr('MSG_IMPORTED')%('<i>%s</i>'%f.filename)
        
        # Insert.
        # -------
        elif btn == self.getZMILangStr('BTN_INSERT'):
          newId = REQUEST.get('_id').strip()
          newAcquired = 0
          newName = REQUEST.get('_name').strip()
          newTitle = REQUEST.get('_title').strip()
          newMethod = REQUEST.get('_type','DTML Method')
          newData = None
          newExec = REQUEST.get('_exec',0)
          id = self.setMetacmd(None, newId, newAcquired, newName, newTitle, newMethod, newData, newExec)
          message = self.getZMILangStr('MSG_INSERTED')%id
        
        # Return with message.
        message = urllib.quote(message)
        return RESPONSE.redirect('manage_main?lang=%s&manage_tabs_message=%s&id=%s'%(lang,message,id))

################################################################################