##############################################################################
#
# Copyright (c) 2005 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Compute a table of object id referrers

$Id: referrers.py 113732 2010-06-21 15:31:11Z ctheune $
"""

from ZODB.serialize import referencesf

def referrers(storage):
    result = {}
    for transaction in storage.iterator():
        for record in transaction:
            for oid in referencesf(record.data):
                result.setdefault(oid, []).append((record.oid, record.tid))
    return result

                
            
