#
# Copyright 2012 Corporation of Balclutha (http://www.balclutha.org)
# 
#                All Rights Reserved
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
#
# Corporation of Balclutha DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS, IN NO EVENT SHALL Corporation of Balclutha BE LIABLE FOR
# ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
# ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE. 
#
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from Products.Zuul.interfaces import IBasicDataSourceInfo
from Products.Zuul.form import schema
from Products.Zuul.utils import ZuulMessageFactory as _t

PROTOS = SimpleVocabulary((SimpleTerm('ldap', 'ldap', 'ldap'), 
                           SimpleTerm('ldaps', 'ldaps', 'ldaps')))

class ILDAPDataSourceInfo(IBasicDataSourceInfo):
    """ connectivity info for a (remote) LDAP server """
    ldapProto = schema.Choice(title=_t(u'LDAP Protocol'), vocabulary=PROTOS)
    ldapPort = schema.Int(title=_t(u'LDAP Port (usually 389 or 636)'))
    ldapDN = schema.Text(title=_t(u'User (Distinguished Name)'))
    ldapPW = schema.Password(title=_t(u'Password'))
    timeout = schema.Int(title=_t(u'Connection Timeout (seconds)'))


