#! /usr/bin/env python

# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program.  If not, see <http://www.gnu.org/licenses/>.

"""Common commands: (see '--help-commands' for more)

  setup.py build      will build the package underneath 'build/'
  setup.py install    will install the package

Global options:
  --verbose (-v)      run verbosely (default)
  --quiet (-q)        run quietly (turns verbosity off)
  --dry-run (-n)      don't actually do anything
  --help (-h)         show detailed help message
  --command-packages  list of packages that provide distutils commands

Information display options (just display information, ignore any commands)
  --help-commands     list all available commands
  --name              print package name
  --version (-V)      print package version
  --fullname          print <package name>-<version>
  --author            print the author's name
  --author-email      print the author's email address
  --maintainer        print the maintainer's name
  --maintainer-email  print the maintainer's email address
  --contact           print the maintainer's name if known, else the author's
  --contact-email     print the maintainer's email address if know, else the
                      author's.
  --url               print the URL for this package
  --license           print the license of the package
  --licence           alias for --license
  --description       print the package description
  --long-description  print the long package description
  --platforms         print the list of platforms
  --classifiers       print the list of classifiers
  --keywords          print the list of keywords
  --provides          print the list of packages/modules provided
  --requires          print the list of packages/modules required
  --obsoletes         print the list of packages/modules made obsolete

usage: setup.py [global_opts] cmd1 [cmd1_opts] [cmd2 [cmd2_opts] ...]
   or: setup.py --help [cmd1 cmd2 ...]
   or: setup.py --help-commands
   or: setup.py cmd --help

"""

from distutils.core import setup
import subprocess
import sys

from valentine.delvian import ab

__author__ = ab.__author__
__version__ = ab.__version__

# Run distutils.core.setup.
if __name__ == '__main__':
    setup(name='ab',
          version=__version__,
          description='Manage your address book.',
          author='Delvian Valentine',
          author_email='djdvalentine@gmail.com',
          url='http://pypi.python.org/pypi/ab/',
          packages=('valentine', 'valentine.delvian'),
          scripts=('ab.py', 'ab-gtk.py'),
          classifiers=('Development Status :: 4 - Beta',
                       'Environment :: Console',
                       'Environment :: X11 Applications :: GTK',
                       'Intended Audience :: End Users/Desktop',
                       'License :: OSI Approved :: GNU General Public License (GPL)',
                       'Natural Language :: English',
                       'Operating System :: POSIX :: Linux',
                       'Programming Language :: Python :: 2.5',
                       'Topic :: Utilities'),
          requires=('cPickle', 'distutils', 'gtk', 'optparse', 'os', 'subprocess', 'sys'),
          provides=('valentine', 'valentine.delvian', 'valentine.delvian.ab'))
    if 'install' in sys.argv:
        try:
            subprocess.call(('xdg-desktop-menu', 'install', '--novendor', 'ab-gtk.desktop'))
        except OSError, err:
            print >> sys.stderr, err
            print >> sys.stderr, 'An operating system error occurred while installing the menu item.'

# (c) 2010 Delvian Valentine <djdvalentine@gmail.com>
