#!/usr/bin/env python2
#coding: utf-8

import os
import sys
import shelve
import socket
import requests
import webbrowser

from __init__      import __version__
from urlparse      import urlparse
from argparse      import ArgumentParser
from BeautifulSoup import BeautifulSoup

env = os.environ
REGISTORY = os.path.join(env["HOME"], ".accounts")

def make_parser():
    parser = ArgumentParser(
                prog="accounts",
                version=__version__,
                description="The accounts saves your accounts of web services.")
    
    subparsers = parser.add_subparsers(
                            dest="command",
                            title="accounts positional arguments.")
    cmd_add = subparsers.add_parser(
                            "add",
                            help="accounts add account to registory.")
    cmd_add.add_argument(
                "service",
                help="any web service name, url, or domain." \
                     "When you set the URL to service, accounts " \
                     "set the service name to domain name.")
    cmd_add.add_argument(
                "account",
                help="your account name.")
    cmd_add.add_argument(
                "-U", "--url",
                help="If you set the not registrated service name, " \
                     "this --url argument can set URL.")



    cmd_upd = subparsers.add_parser(
                            "upd",
                            help="accounts updates the account name.")
    cmd_upd.add_argument(
                "service",
                help="your registrated service name.")           
    cmd_upd.add_argument(
                "account",
                help="the account name what you want update")



    cmd_del = subparsers.add_parser(
                             "del",
                             help="accounts deletes the service account.")
    cmd_del.add_argument(
                "service",
                help="your registrated service name.")           



    cmd_login = subparsers.add_parser(
                            "login",
                            help="accounts opens browser to login the service.")
    cmd_login.add_argument(
                "service",
                help="your registrated service name.")
    
    cmd_list = subparsers.add_parser(
                            "list",
                            help="accounts shows the list of accounts.")

    return parser

class ServiceError(BaseException):
    pass

def adjust_service(service):
    if service.startswith("http") or \
            service.startswith("https") or \
                service.startswith("ftp"):

        res = requests.get(service)
        if res.status_code == 200:
            # url
            parsed = urlparse(service)
            return parsed.netloc.split(".")[0]

        else:
            raise ServiceError("service (url) not found.")

    if service.find(".") == -1:
        # nomal
        return service
    
    else:
        try:
            host = socket.gethostbyname(service)
            # domain
            return service.split(".")[0]

        except socket.gaierror:
            raise ServiceError("service (domain) not found.")

def get_module(directory, file_name, obj_name):

    modules = {}
    path = os.path.join(directory,file_name)

    nowdir = os.getcwd()
    os.chdir(directory)

    execfile(path, globals(), modules)

    os.chdir(nowdir)
    return modules[obj_name]

def get_service(string):

    basedir = os.path.dirname(os.path.abspath(__file__))
    services_dir = os.path.join(basedir, "services")

    services = [item for item in 
                        os.listdir(services_dir) if item.endswith(".py")]

    for service in services:
        srv = service.replace(".py","")
        if string == srv:
            # exist service
            # import service class from file, and return class object
            return get_module(services_dir, service, srv.title())

    # not exist service
    # import original Service class from file, and return class object
    module = get_module(services_dir, "__init__.py", "Service")
    name, url, login_url = fetch_Google(string)
    module.name = name
    module.url = url
    module.login_url = login_url
    return module


def fetch_Google(service):

    url = "http://www.google.co.jp/search?hl=ja&num=1&q="

    res = requests.get(url+service)
    soup = BeautifulSoup(res.text)

    base = soup.findAll("h3", {"class":"r"})[0]
    name = base.text
    url = "http://" + base.a["href"][7:].split("/")[2]
    login_url = url+"/login"
    return (name, url, login_url)


def main():

    parser = make_parser()

    if len(sys.argv) == 1:
        parser.parse_args(["-h"])

    args = parser.parse_args()

    if args.command == "add":

        service = get_service(adjust_service(args.service))
        data = \
            {
                "service": service.name,
                "account": args.account,
                "url": service.url,
                "login_url": service.login_url,
            }

        registory = shelve.open(REGISTORY)

        if not registory.has_key("accounts"):
            registory["accounts"] = [data]
        else:
            d = registory["accounts"]
            d.append(data)
            registory["accounts"] = d

        registory.close()

        print "accounts saves the %(service)s account: %(account)s" % data
        return 0

    elif args.command == "list":

        registory = shelve.open(REGISTORY)

        if not registory.has_key("accounts") or registory["accounts"] == []:
            print "you still don't save service."
            return 1

        print "accounts:"
        for info in registory["accounts"]:
            print "  - " + info["service"] + ": " + info["account"]

        return 0

    elif args.command == "upd":

        registory = shelve.open(REGISTORY)
        data = registory["accounts"]

        for d in data:
            if args.service == d["service"]:
                index = data.index(d)

                original = d["account"]
                service = d["service"]
                url = d["url"]
                login_url = d["login_url"]

                data.pop(index)
                data.append({
                    "service": service,
                    "account": args.account,
                    "url":     url,
                    "login_url": login_url
                })

                registory["accounts"] = data
                registory.close()
                print "accounts updates the %s service: %s -> %s" % (d["service"], original, args.account)
                return 0

        raise ServiceError("service not found.")

    elif args.command == "del":

        registory = shelve.open(REGISTORY)
        data = registory["accounts"]

        for d in data:
            if args.service == d["service"]:
                index = data.index(d)
                data.pop(index)

                registory["accounts"] = data
                registory.close()
                print "accounts deletes the %s account." % args.service
                return 0

        raise ServiceError("service not found.")

    elif args.command == "login":

        registory = shelve.open(REGISTORY)

        if not registory.has_key("accounts") or registory["accounts"] == []:
            print "you still don't save service."
            return 1

        data = registory["accounts"]

        for d in data:
            if args.service == d["service"]:
                login_url = d["login_url"]
                webbrowser.open(login_url)

if __name__ == "__main__":

    sys.exit(main())
