#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by Grako.
#
#    https://pypi.python.org/pypi/grako/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals
from grako.parsing import graken, Parser


__version__ = (2014, 11, 10, 16, 51, 18, 0)

__all__ = [
    'grammarParser',
    'grammarSemantics',
    'main'
]


class grammarParser(Parser):
    def __init__(self, whitespace=None, nameguard=True, **kwargs):
        super(grammarParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            **kwargs
        )

    @graken()
    def _start_(self):

        def block1():
            self._rule_()
        self._positive_closure(block1)

        self.ast['@'] = self.last_node
        self._check_eof()

    @graken()
    def _options_(self):
        with self._choice():
            with self._option():
                self._state_expr_()
                self.ast['state'] = self.last_node
            with self._option():
                self._log_expr_()
                self.ast['log'] = self.last_node
            with self._option():
                self._expire_expr_()
                self.ast['expire'] = self.last_node
            with self._option():
                self._comment_expr_()
                self.ast['comment'] = self.last_node
            self._error('no available options')

        self.ast._define(
            ['state', 'log', 'expire', 'comment'],
            []
        )

    @graken()
    def _optional_keywords_(self):

        def block0():
            with self._choice():
                with self._option():
                    self._state_expr_()
                    self.ast['state'] = self.last_node
                with self._option():
                    self._log_expr_()
                    self.ast['log'] = self.last_node
                with self._option():
                    self._expire_expr_()
                    self.ast['expire'] = self.last_node
                with self._option():
                    self._comment_expr_()
                    self.ast['comment'] = self.last_node
                self._error('no available options')
        self._closure(block0)

        self.ast._define(
            ['state', 'log', 'expire', 'comment'],
            []
        )

    @graken()
    def _rule_(self):
        self._action_expr_()
        self.ast['action'] = self.last_node
        self._cut()
        self._protocol_expr_()
        self.ast['protocol'] = self.last_node
        self._cut()
        self._source_expr_()
        self.ast['source'] = self.last_node
        self._cut()
        self._dst_expr_()
        self.ast['destination'] = self.last_node
        self._cut()
        self._optional_keywords_()
        self.ast['keywords'] = self.last_node

        self.ast._define(
            ['action', 'protocol', 'source', 'destination', 'keywords'],
            []
        )

    @graken()
    def _state_expr_(self):
        self._token('stateful')
        self._cut()

    @graken()
    def _log_expr_(self):
        self._token('log')
        self._cut()

    @graken()
    def _expire_expr_(self):
        self._token('expire')
        self._date_()
        self.ast['@'] = self.last_node
        self._cut()

    @graken()
    def _date_(self):
        self._pattern(r'[0-9]{8}')

    @graken()
    def _action_expr_(self):
        with self._choice():
            with self._option():
                self._token('allow')
            with self._option():
                self._token('deny')
            self._error('expecting one of: allow deny')

    @graken()
    def _protocol_expr_(self):
        with self._choice():
            with self._option():
                self._token('udp')
                self.ast['@'] = self.last_node
                self._cut()
            with self._option():
                self._token('tcp')
                self.ast['@'] = self.last_node
                self._cut()
            with self._option():
                self._token('any')
                self.ast['@'] = self.last_node
                self._cut()
            with self._option():
                self._icmp_expr_()
                self.ast['icmp'] = self.last_node
                self._cut()
            self._error('expecting one of: any tcp udp')

        self.ast._define(
            ['icmp'],
            []
        )

    @graken()
    def _icmp_expr_(self):
        self._token('icmp')
        self._icmp_term_()
        self.ast['@'] = self.last_node

    @graken()
    def _icmp_term_(self):
        with self._choice():
            with self._option():
                self._token('any')
                self.ast['@'] = self.last_node
                self._cut()
            with self._option():
                self._number_()
                self.ast['icmp_type'] = self.last_node
                self._icmp_code_()
                self.ast['icmp_code'] = self.last_node
            with self._option():
                self._group_expr_()
                self.ast['include'] = self.last_node
                self._cut()
            self._error('expecting one of: any')

        self.ast._define(
            ['icmp_type', 'icmp_code', 'include'],
            []
        )

    @graken()
    def _icmp_number_(self):
        self._number_()

    @graken()
    def _icmp_code_(self):
        with self._choice():
            with self._option():
                self._icmp_number_()
            with self._option():
                self._token('any')
            self._error('expecting one of: any')

    @graken()
    def _comment_expr_(self):
        self._token('#')
        self._pattern(r'.*$')
        self.ast['@'] = self.last_node

    @graken()
    def _string_(self):
        self._pattern(r'[a-zA-Z0-9_-]+')

    @graken()
    def _STRING_(self):
        self._string_()

    @graken()
    def _address_string_(self):
        self._pattern(r'[a-fA-F0-9\.:\/]+')

    @graken()
    def _source_expr_(self):
        self._token('src')
        self._cut()
        self._endpoint_tuple_()
        self.ast['@'] = self.last_node

    @graken()
    def _dst_expr_(self):
        self._token('dst')
        self._cut()
        self._endpoint_tuple_()
        self.ast['@'] = self.last_node

    @graken()
    def _endpoint_tuple_(self):
        self._endpoint_expr_()
        self.ast['l3'] = self.last_node
        self._portgroup_expr_()
        self.ast['l4'] = self.last_node
        self._cut()

        self.ast._define(
            ['l3', 'l4'],
            []
        )

    @graken()
    def _endpoint_list_(self):

        def block1():
            self._prefix_()
        self._positive_closure(block1)

        self.ast['@'] = self.last_node
        self._check_eof()

    @graken()
    def _endpoint_expr_(self):
        with self._choice():
            with self._option():
                self._token('any')
                self.ast.setlist('ip', self.last_node)
            with self._option():
                self._prefix_()
                self.ast.setlist('ip', self.last_node)
            with self._option():
                self._group_expr_()
                self.ast['include'] = self.last_node
            self._error('expecting one of: any')

        self.ast._define(
            ['include'],
            ['ip']
        )

    @graken()
    def _group_expr_(self):
        self._token('@')
        self._cut()
        self._string_()
        self.ast['@'] = self.last_node

    @graken()
    def _portgroup_expr_(self):
        with self._optional():
            self._token('port')
            self._port_term_()
            self.ast['@'] = self.last_node

    @graken()
    def _port_term_(self):
        with self._choice():
            with self._option():
                self._token('any')
                self.ast.setlist('ports', self.last_node)
                self._cut()
            with self._option():
                self._group_expr_()
                self.ast['include'] = self.last_node
                self._cut()
            with self._option():

                def block3():
                    self._port_atoms_()
                self._closure(block3)
                self.ast['ports'] = self.last_node
                self._cut()
            self._error('expecting one of: any ~')

        self.ast._define(
            ['include', 'ports'],
            ['ports']
        )

    @graken()
    def _port_atoms_(self):
        self._port_expr_()
        self.ast.setlist('@', self.last_node)

        def block1():
            self._token(',')
            self._port_expr_()
            self.ast.setlist('@', self.last_node)
        self._closure(block1)
        self._cut()

    @graken()
    def _port_expr_(self):
        with self._choice():
            with self._option():
                self._port_range_()
                self.ast['range'] = self.last_node
                self._cut()
            with self._option():
                self._port_number_()
                self.ast['single'] = self.last_node
                self._cut()
            self._error('no available options')

        self.ast._define(
            ['range', 'single'],
            []
        )

    @graken()
    def _port_range_(self):
        self._NUMBER_()
        self.ast['@'] = self.last_node
        self._token('-')
        self._NUMBER_()
        self.ast['@'] = self.last_node
        self._cut()

    @graken()
    def _port_number_(self):
        self._NUMBER_()
        self._cut()

    @graken()
    def _number_(self):
        self._NUMBER_()
        self._cut()

    @graken()
    def _prefix_(self):
        self._address_string_()
        self._cut()

    @graken()
    def _NUMBER_(self):
        self._pattern(r'[0-9]+')


class grammarSemantics(object):
    def start(self, ast):
        return ast

    def options(self, ast):
        return ast

    def optional_keywords(self, ast):
        return ast

    def rule(self, ast):
        return ast

    def state_expr(self, ast):
        return ast

    def log_expr(self, ast):
        return ast

    def expire_expr(self, ast):
        return ast

    def date(self, ast):
        return ast

    def action_expr(self, ast):
        return ast

    def protocol_expr(self, ast):
        return ast

    def icmp_expr(self, ast):
        return ast

    def icmp_term(self, ast):
        return ast

    def icmp_number(self, ast):
        return ast

    def icmp_code(self, ast):
        return ast

    def comment_expr(self, ast):
        return ast

    def string(self, ast):
        return ast

    def STRING(self, ast):
        return ast

    def address_string(self, ast):
        return ast

    def source_expr(self, ast):
        return ast

    def dst_expr(self, ast):
        return ast

    def endpoint_tuple(self, ast):
        return ast

    def endpoint_list(self, ast):
        return ast

    def endpoint_expr(self, ast):
        return ast

    def group_expr(self, ast):
        return ast

    def portgroup_expr(self, ast):
        return ast

    def port_term(self, ast):
        return ast

    def port_atoms(self, ast):
        return ast

    def port_expr(self, ast):
        return ast

    def port_range(self, ast):
        return ast

    def port_number(self, ast):
        return ast

    def number(self, ast):
        return ast

    def prefix(self, ast):
        return ast

    def NUMBER(self, ast):
        return ast


def main(filename, startrule, trace=False, whitespace=None):
    import json
    with open(filename) as f:
        text = f.read()
    parser = grammarParser(parseinfo=False)
    ast = parser.parse(
        text,
        startrule,
        filename=filename,
        trace=trace,
        whitespace=whitespace)
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(ast, indent=2))
    print()

if __name__ == '__main__':
    import argparse
    import string
    import sys

    class ListRules(argparse.Action):
        def __call__(self, parser, namespace, values, option_string):
            print('Rules:')
            for r in grammarParser.rule_list():
                print(r)
            print()
            sys.exit(0)

    parser = argparse.ArgumentParser(description="Simple parser for grammar.")
    parser.add_argument('-l', '--list', action=ListRules, nargs=0,
                        help="list all rules and exit")
    parser.add_argument('-t', '--trace', action='store_true',
                        help="output trace information")
    parser.add_argument('-w', '--whitespace', type=str, default=string.whitespace,
                        help="whitespace specification")
    parser.add_argument('file', metavar="FILE", help="the input file to parse")
    parser.add_argument('startrule', metavar="STARTRULE",
                        help="the start rule for parsing")
    args = parser.parse_args()

    main(
        args.file,
        args.startrule,
        trace=args.trace,
        whitespace=args.whitespace
    )

