# -*- coding: utf-8 -*-
"""
Global configuration file for TG2-specific settings in acr.

This file complements development/deployment.ini.

Please note that **all the argument values are strings**. If you want to
convert them into boolean, for example, you should use the
:func:`paste.deploy.converters.asbool` function, as in::
    
    from paste.deploy.converters import asbool
    setting = asbool(global_conf.get('the_setting'))
 
"""

from tg.configuration import AppConfig

import acr
from acr import model
from acr.lib import app_globals, helpers

from acr.lib.multisite import AcrAuthenticatorPlugin
from repoze.who.middleware import PluggableAuthenticationMiddleware
from repoze.who.plugins.friendlyform import FriendlyFormPlugin
from repoze.who.plugins.auth_tkt import AuthTktCookiePlugin

class AcrCmsMultiSiteConfig(AppConfig):
	def add_auth_middleware(self, app, skip_authentication):
	    form_plugin = FriendlyFormPlugin('/login', '/login_handler', '/post_login', '/logout_handler', '/post_logout',
				      login_counter_name=None,
				      rememberer_name='cookie')

	    challengers = [('form', form_plugin)]
	    authenticators = [('acr_auth', AcrAuthenticatorPlugin(model.User, model.DBSession))]
	    mdproviders = [('acr_meta', AcrAuthenticatorPlugin(model.User, model.DBSession))]
		  
	    cookie = AuthTktCookiePlugin(self.sa_auth.cookie_secret, 'acrauth')
	    identifiers = [('cookie', cookie), ('form', form_plugin)]

	    from repoze.who.classifiers import default_request_classifier
	    from repoze.who.classifiers import default_challenge_decider
	    
	    app = PluggableAuthenticationMiddleware(app,
						  identifiers,
						  authenticators,
						  challengers,
						  mdproviders,
						  default_request_classifier,
						  default_challenge_decider)
	 
	    return app

base_config = AcrCmsMultiSiteConfig()
base_config.renderers = []

base_config.package = acr

#Set the default renderer
base_config.default_renderer = 'genshi'
base_config.renderers.append('genshi')

#NEEDED WHEN USING TG2.1
base_config.renderers.append('json')
base_config.sa_auth.cookie_secret = 'mycookiesecret'

# if you want raw speed and have installed chameleon.genshi
# you should try to use this renderer instead.
# warning: for the moment chameleon does not handle i18n translations
#base_config.renderers.append('chameleon_genshi')

#Configure the base SQLALchemy Setup
base_config.use_sqlalchemy = True
base_config.model = acr.model
base_config.DBSession = acr.model.DBSession

# Configure the authentication backend
base_config.auth_backend = 'sqlalchemy'
base_config.sa_auth.dbsession = model.DBSession
# what is the class you want to use to search for users in the database
base_config.sa_auth.user_class = model.User
# what is the class you want to use to search for groups in the database
base_config.sa_auth.group_class = model.Group
# what is the class you want to use to search for permissions in the database
base_config.sa_auth.permission_class = model.Permission

# override this if you would like to provide a different who plugin for
# managing login and logout of your application
base_config.sa_auth.form_plugin = None

# You may optionally define a page where you want users to be redirected to
# on login:
base_config.sa_auth.post_login_url = '/post_login'

# You may optionally define a page where you want users to be redirected to
# on logout:
base_config.sa_auth.post_logout_url = '/post_logout'
