# -*- coding: utf-8 -*-
try:
    from setuptools import setup, find_packages
except ImportError:
    from ez_setup import use_setuptools
    use_setuptools()
    from setuptools import setup, find_packages

version='0.2'

setup(
    name='acr',
    version=version,
    description='ACRCms is an open source Python web content management system based on Turbogears and libacr',
    long_decription="""\
The ACR project has born in 2009 as a library to be imported inside any Turbogears application to provide a
way to quickly create web pages and manage their content.
After releasing it as open source the AXANT team thought that it would have been useful to provide an example
on how to use it and created ACRCms which is a Python web content management system based on libacr.

Currently ACRCms supports:

    * Multilanguage Content
    * Content versioning and reverting
    * Image and HTML5 Video Galleries
    * News/Blog Sections
    * User permissions management
    * Autogenerated Vertical/Horizontal Menus
    * Internal Search Engine
    * Youtube Videos embedding
    * Remote Disk to upload and manage files
    * RSS Integration (import and export content using RSS)
    * Twitter Integration (import your tweets)
    * Static and Dynamic Google Maps
    * Comments
    * Automatic Forms generation with email submission of data
    * An extensible plugin architecture to add new functions any time
    * Uservoice feedback plugin
    * Themes directly editable within the Administration area
    * Google Analytics plugin for stats
    * Various king of slideshows

Plans for the future include layout management interface and a rich set of plugins,
if you want to contribute feel free to send an email at: tech [at] axant.it
""",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Environment :: Web Environment",
        "Framework :: TurboGears",
        "License :: OSI Approved :: GNU General Public License (GPL)",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Topic :: Internet :: WWW/HTTP :: Dynamic Content",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    keywords='tg2 cms cmf web',
    author='AXANT',
    author_email='tech@axant.it',
    url='http://www.acrcms.org',
    license='GPL',
    install_requires=[
        "TurboGears2 >= 2.0b7",
        "Babel >=0.9.4",
        "zope.sqlalchemy >= 0.4 ",
        "repoze.tm2 >= 1.0a4",
        "repoze.what-quickstart >= 1.0",
        "feedparser",
        "tw.jquery",
        "tw.tinymce",
        "BeautifulSoup",
        "PIL",
        "sprox",
        "tgext.admin",
        "libacr",
    ],
    zip_safe=False,
    setup_requires=["PasteScript >= 1.7"],
    paster_plugins=['PasteScript', 'Pylons', 'TurboGears2', 'tg.devtools'],
    packages=find_packages(exclude=['ez_setup']),
    include_package_data=True,
    test_suite='nose.collector',
    tests_require=['WebTest', 'BeautifulSoup'],
    package_data={'acr': ['i18n/*/LC_MESSAGES/*.mo',
                                 'templates/*/*',
                                 'public/*/*',
                                 'acr_plugins/*/*.html',
                                 'acr_plugins/*/static/*.*']},
    message_extractors={'acr': [
            ('**.py', 'python', None),
            ('templates/**.mako', 'mako', None),
            ('templates/**.html', 'genshi', None),
            ('public/**', 'ignore', None)]},

    entry_points="""
    [paste.app_factory]
    main = acr.config.middleware:make_app

    [paste.app_install]
    main = pylons.util:PylonsInstaller
    """,
)
