from setuptools import setup, find_packages

setup(
    name='addonpy',
    version='0.8.0',
    author='Ninad Mhatre',
    author_email='ninad.mhatre@gmail.com',
    packages=['addonpy',
              'addonpy.tests',
              'addonpy.tests.data',
              'addonpy.tests.data.sub',
              'addonpy.examples',
              'addonpy.docs',
              'addonpy.scripts',
              'addonpy.examples.Default',
              'addonpy.examples.Default.Hook'],
    package_data={'addonpy.tests': ['*.bat', '*.txt'],
                  'addonpy.tests.data': ['*.info'],
                  'addonpy.tests.data.sub': ['*.info'],
                  'addonpy.examples': ['*.txt', '*.info'],
                  'addonpy.docs': ['*.html'],
                  'addonpy': ['.version'],
                  'addonpy.scripts': ['*.conf']},
    url='https://github.com/ninadmhatre/addonpy/wiki',
    license='MIT',
    description='A simple addon/plug-in module',
    scripts=['addonpy/scripts/addon_generator.py'],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
)
