import os, os.path
import re
from time import time

from BeautifulSoup import BeautifulSoup

from pylons.i18n import _, get_lang

from adhocracy.lib.base import *

log = logging.getLogger(__name__)

VALID_PAGE = re.compile("^[a-zA-Z0-9\_\-]*$")
STATIC_PATH = os.path.join(config.get('here'), 'adhocracy', 'page')

class StaticController(BaseController):
    
    def serve(self, page_name, format='html'):
        begin_time = time()
        c.static = StaticPage(page_name)
        if not c.static.exists:
            abort(404, _('The requested page was not found'))
        if format == 'simple':
            ret = render('/plain_doc.html')
        else:
            ret = render('/template_doc.html')
        log.debug("Rendering static %s took %sms" % (page_name, ((time()-begin_time)*1000)))
        return ret