/*!
 * jsUri
 * https://github.com/derek-watson/jsUri
 *
 * Copyright 2012, Derek Watson
 * Released under the MIT license.
 *
 * Includes parseUri regular expressions
 * http://blog.stevenlevithan.com/archives/parseuri
 * Copyright 2007, Steven Levithan
 * Released under the MIT license.
 *
 * Fork by Slik
 * https://github.com/SlikNL/jsUri
 * (at least until our pull is merged at
 * https://github.com/derek-watson/jsUri/pull/18)
 */
(function(global){if(!Array.prototype.forEach){Array.prototype.forEach=function(fn,scope){for(var i=0,len=this.length;i<len;++i){fn.call(scope||this,this[i],i,this)}}}function decode(s){s=decodeURIComponent(s);s=s.replace("+"," ");return s}function parseUri(str){var parser=/^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/,parserKeys=["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],m=parser.exec(str||""),parts={};parserKeys.forEach(function(key,i){parts[key]=m[i]||""});return parts}function parseQuery(str){var i,ps,p,kvp,k,v,pairs=[];if(typeof str==="undefined"||str===null||str===""){return pairs}if(str.indexOf("?")===0){str=str.substring(1)}ps=str.toString().split(/[&;]/);for(i=0;i<ps.length;i++){p=ps[i];kvp=p.split("=");k=kvp[0];v=p.indexOf("=")===-1?null:kvp[1]===null?"":kvp[1];v=v&&decodeURIComponent(v);pairs.push([k,v])}return pairs}function Uri(str){this.uriParts=parseUri(str);this.queryPairs=parseQuery(this.uriParts.query);this.hasAuthorityPrefixUserPref=null}["protocol","userInfo","host","port","path","anchor"].forEach(function(key){Uri.prototype[key]=function(val){if(typeof val!=="undefined"){this.uriParts[key]=val}return this.uriParts[key]}});Uri.prototype.hasAuthorityPrefix=function(val){if(typeof val!=="undefined"){this.hasAuthorityPrefixUserPref=val}if(this.hasAuthorityPrefixUserPref===null){return this.uriParts.source.indexOf("//")!==-1}else{return this.hasAuthorityPrefixUserPref}};Uri.prototype.query=function(val){var s="",i,param;if(typeof val!=="undefined"){this.queryPairs=parseQuery(val)}for(i=0;i<this.queryPairs.length;i++){param=this.queryPairs[i];if(s.length>0){s+="&"}if(param[1]===null){s+=param[0]}else{s+=param[0];s+="=";if(param[1]){s+=encodeURIComponent(param[1])}}}return s.length>0?"?"+s:s};Uri.prototype.getQueryParamValue=function(key){var param,i;for(i=0;i<this.queryPairs.length;i++){param=this.queryPairs[i];if(decode(key)===decode(param[0])){return param[1]}}};Uri.prototype.getQueryParamValues=function(key){var arr=[],i,param;for(i=0;i<this.queryPairs.length;i++){param=this.queryPairs[i];if(decode(key)===decode(param[0])){arr.push(param[1])}}return arr};Uri.prototype.deleteQueryParam=function(key,val){var arr=[],i,param,keyMatchesFilter,valMatchesFilter;for(i=0;i<this.queryPairs.length;i++){param=this.queryPairs[i];keyMatchesFilter=decode(param[0])===decode(key);valMatchesFilter=param[1]===val;if(arguments.length===1&&!keyMatchesFilter||arguments.length===2&&!keyMatchesFilter&&!valMatchesFilter){arr.push(param)}}this.queryPairs=arr;return this};Uri.prototype.addQueryParam=function(key,val,index){if(arguments.length===3&&index!==-1){index=Math.min(index,this.queryPairs.length);this.queryPairs.splice(index,0,[key,val])}else if(arguments.length>0){this.queryPairs.push([key,val])}return this};Uri.prototype.replaceQueryParam=function(key,newVal,oldVal){var index=-1,i,param;if(arguments.length===3){for(i=0;i<this.queryPairs.length;i++){param=this.queryPairs[i];if(decode(param[0])===decode(key)&&decodeURIComponent(param[1])===decode(oldVal)){index=i;break}}this.deleteQueryParam(key,oldVal).addQueryParam(key,newVal,index)}else{for(i=0;i<this.queryPairs.length;i++){param=this.queryPairs[i];if(decode(param[0])===decode(key)){index=i;break}}this.deleteQueryParam(key);this.addQueryParam(key,newVal,index)}return this};["protocol","hasAuthorityPrefix","userInfo","host","port","path","query","anchor"].forEach(function(key){var method="set"+key.charAt(0).toUpperCase()+key.slice(1);Uri.prototype[method]=function(val){this[key](val);return this}});Uri.prototype.scheme=function(){var s="";if(this.protocol()){s+=this.protocol();if(this.protocol().indexOf(":")!==this.protocol().length-1){s+=":"}s+="//"}else{if(this.hasAuthorityPrefix()&&this.host()){s+="//"}}return s};Uri.prototype.origin=function(){var s=this.scheme();if(this.userInfo()&&this.host()){s+=this.userInfo();if(this.userInfo().indexOf("@")!==this.userInfo().length-1){s+="@"}}if(this.host()){s+=this.host();if(this.port()){s+=":"+this.port()}}return s};Uri.prototype.toString=function(){var s=this.origin();if(this.path()){s+=this.path()}else{if(this.host()&&(this.query().toString()||this.anchor())){s+="/"}}if(this.query().toString()){if(this.query().toString().indexOf("?")!==0){s+="?"}s+=this.query().toString()}if(this.anchor()){if(this.anchor().indexOf("#")!==0){s+="#"}s+=this.anchor()}return s};Uri.prototype.clone=function(){return new Uri(this.toString())};if(typeof module==="undefined"){global.Uri=Uri}else{module.exports=Uri}})(this);
