# -*- coding: utf-8 -*-
from adhocracy.tests import TestController


TEST_IMAGE = (
    b'GIF89a\x10\x00\x10\x00\xd5\x00\x00\xff\xff\xff\xff\xff\xfe\xfc\xfd\xfd'
    b'\xfa\xfb\xfc\xf7\xf9\xfa\xf5\xf8\xf9\xf3\xf6\xf8\xf2\xf5\xf7\xf0\xf4\xf6'
    b'\xeb\xf1\xf3\xe5\xed\xef\xde\xe8\xeb\xdc\xe6\xea\xd9\xe4\xe8\xd7\xe2\xe6'
    b'\xd2\xdf\xe3\xd0\xdd\xe3\xcd\xdc\xe1\xcb\xda\xdf\xc9\xd9\xdf\xc8\xd8\xdd'
    b'\xc6\xd7\xdc\xc4\xd6\xdc\xc3\xd4\xda\xc2\xd3\xd9\xc1\xd3\xd9\xc0\xd2\xd9'
    b'\xbd\xd1\xd8\xbd\xd0\xd7\xbc\xcf\xd7\xbb\xcf\xd6\xbb\xce\xd5\xb9\xcd\xd4'
    b'\xb6\xcc\xd4\xb6\xcb\xd3\xb5\xcb\xd2\xb4\xca\xd1\xb2\xc8\xd0\xb1\xc7\xd0'
    b'\xb0\xc7\xcf\xaf\xc6\xce\xae\xc4\xce\xad\xc4\xcd\xab\xc3\xcc\xa9\xc2\xcb'
    b'\xa8\xc1\xca\xa6\xc0\xc9\xa4\xbe\xc8\xa2\xbd\xc7\xa0\xbb\xc5\x9e\xba\xc4'
    b'\x9b\xbf\xcc\x98\xb6\xc1\x8d\xae\xbaFgs\x00\x00\x00\x00\x00\x00\x00\x00'
    b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
    b'\x00,\x00\x00\x00\x00\x10\x00\x10\x00\x00\x06z@\x80pH,\x12k\xc8$\xd2f'
    b'\x04\xd4\x84\x01\x01\xe1\xf0d\x16\x9f\x80A\x01\x91\xc0ZmL\xb0\xcd\x00V'
    b'\xd4\xc4a\x87z\xed\xb0-\x1a\xb3\xb8\x95\xbdf8\x1e\x11\xca,MoC$\x15\x18{'
    b'\x006}m\x13\x16\x1a\x1f\x83\x85}6\x17\x1b $\x83\x00\x86\x19\x1d!%)\x8c'
    b'\x866#\'+.\x8ca`\x1c`(,/1\x94B5\x19\x1e"&*-024\xacNq\xba\xbb\xb8h\xbeb'
    b'\x00A\x00;'
)


class TestBadgeHelper(TestController):

    def test_generate_thumbnail_tag_no_color_no_thumb_attr(self):
        from adhocracy.model import ThumbnailBadge
        from adhocracy.lib.helpers.badge_helper import generate_thumbnail_tag
        badge = ThumbnailBadge.create(u'testbadge0', u'', True, u'descr')
        image = generate_thumbnail_tag(badge)
        self.assert_(b'b96ZYAAAAASUVORK5CYII=' in image)

    def test_generate_thumbnail_tag_with_color_attr(self):
        from adhocracy.model import ThumbnailBadge
        from adhocracy.lib.helpers.badge_helper import generate_thumbnail_tag
        badge = ThumbnailBadge.create(u'testbadge0', u'#ccc', True, u'descr')
        image = generate_thumbnail_tag(badge)
        self.assert_(b'Afb96ZYAAAAASUVORK5CYII=' in image)

    def test_generate_thumbnail_tag_with_thumb_attr(self):
        from adhocracy.model import ThumbnailBadge
        from adhocracy.lib.helpers.badge_helper import generate_thumbnail_tag
        badge = ThumbnailBadge.create(u'testbadge0', u'#ccc', True, u'descr')
        badge.thumbnail = TEST_IMAGE
        image = generate_thumbnail_tag(badge)
        self.assert_(b'VWyKXFMAAAAASUVORK5CYII=' in image)

    def test_generate_thumbnail_tag_set_size(self):
        from adhocracy.model import ThumbnailBadge, Instance
        from adhocracy.lib.helpers.badge_helper import generate_thumbnail_tag
        instance = Instance.find(u'test')
        badge = ThumbnailBadge.create(u'testbadge0', u'', True, u'descr')
        badge.instance = instance
        image = generate_thumbnail_tag(badge)
        self.assert_(u'width="48"' in image)
        self.assert_(u'height="48"' in image)
        instance.thumbnailbadges_width = 10
        instance.thumbnailbadges_height = 12
        image = generate_thumbnail_tag(badge)
        self.assert_(u'height="12"' in image)
        self.assert_(u'width="10"' in image)
        image = generate_thumbnail_tag(badge, width=8, height=11)
        self.assert_(u'height="11"' in image)
        self.assert_(u'width="8"' in image)

    def test_generate_thumbnail_cache(self):
        from adhocracy.model import ThumbnailBadge
        from adhocracy.lib.helpers.badge_helper import generate_thumbnail_tag
        badge = ThumbnailBadge.create(u'testbadge0', u'', True, u'descr')
        image = generate_thumbnail_tag(badge)
        self.assert_(b'fb96ZYAAAAASUVORK5CYII=' in image)
        badge.thumbnail = TEST_IMAGE
        image = generate_thumbnail_tag(badge)
        self.assert_(b'VWyKXFMAAAAASUVORK5CYII=' in image)
        badge.thumbnail = "Wrong Data"
        image = generate_thumbnail_tag(badge)
        self.assert_(b'fb96ZYAAAAASUVORK5CYII=' in image)

    def test_get_parent_badges_no_hierarchy(self):
        from adhocracy.model import UserBadge
        from adhocracy.lib.helpers.badge_helper import get_parent_badges
        badge = UserBadge.create(u'testbadge', u'#ccc', True, u'description')
        result = [b.title for b in get_parent_badges(badge)]
        shouldbe = []
        self.assertEqual(result, shouldbe)

    def test_get_parent_badges_with_hierarchy(self):
        from adhocracy.model import CategoryBadge
        from adhocracy.lib.helpers.badge_helper import get_parent_badges
        badge0 = CategoryBadge.create(u'testbadge0', u'#ccc', True, u'descr')
        badge11 = CategoryBadge.create(u'testbadge11', u'#ccc', True, u'descr')
        badge12 = CategoryBadge.create(u'testbadge12', u'#ccc', True, u'descr')
        badge121 = CategoryBadge.create(u'testbadge121', u'#ccc', True,
                                        u'descr')
        badge11.parent = badge0
        badge12.parent = badge0
        badge121.parent = badge12
        result = [b.title for b in get_parent_badges(badge121)]
        shouldbe = ['testbadge12', u'testbadge0']
        self.assertEqual(result, shouldbe)


class TestSiteHelper(TestController):
    def _make_content(self):
        """Returns instance and user"""

        from adhocracy import model

        instance = model.Instance.find(u'test')
        user = model.User.create(u'user', u'user@mail.com')

        return instance, user

    def test_is_local_url_empty(self):
        from adhocracy.lib import helpers as h

        self.assert_(not h.site.is_local_url(''))
        self.assert_(not h.site.is_local_url(None))

    def test_is_local_url_domain(self):
        from adhocracy.lib import helpers as h
        from adhocracy import config

        self.assert_(h.site.is_local_url(
            '//' + config.get(u'adhocracy.domain')))
        self.assert_(not h.site.is_local_url('http://evil.com'))

    def test_is_local_url_subdomain(self):
        from adhocracy.lib import helpers as h
        from adhocracy import config

        self.assert_(h.site.relative_urls() ^ h.site.is_local_url(
            u'//subdomain.' + config.get(u'adhocracy.domain')))
        self.assert_(not h.site.is_local_url(
            u'//subsub.sub.' + config.get(u'adhocracy.domain')))

    def test_is_local_url_relative(self):
        from adhocracy.lib import helpers as h

        self.assert_(h.site.is_local_url('/i/test'))
        self.assert_(h.site.is_local_url('relative_path'))

    def test_is_local_url_entity(self):
        from adhocracy.lib import helpers as h

        instance, user = self._make_content()

        self.assert_(h.site.is_local_url(h.entity_url(user)))
        self.assert_(h.site.is_local_url(h.entity_url(instance)))
