# Copyright (C) 2011 by Mark Visser <mjmvisser@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# This code is based on the AMD Display Library 3.0 SDK

ADL_TRUE = 1     # ADL_SDK_3.0/include/adl_defines.h:52
ADL_FALSE = 0     # ADL_SDK_3.0/include/adl_defines.h:55
ADL_MAX_CHAR = 4096     # ADL_SDK_3.0/include/adl_defines.h:59
ADL_MAX_PATH = 256     # ADL_SDK_3.0/include/adl_defines.h:62
ADL_MAX_ADAPTERS = 150     # ADL_SDK_3.0/include/adl_defines.h:65
ADL_MAX_DISPLAYS = 150     # ADL_SDK_3.0/include/adl_defines.h:68
ADL_MAX_DEVICENAME = 32     # ADL_SDK_3.0/include/adl_defines.h:71
ADL_ADAPTER_INDEX_ALL = -1     # ADL_SDK_3.0/include/adl_defines.h:74
ADL_MAIN_API_OPTION_NONE = 0     # ADL_SDK_3.0/include/adl_defines.h:77
ADL_DDC_OPTION_SWITCHDDC2 = 1     # ADL_SDK_3.0/include/adl_defines.h:90
ADL_DDC_OPTION_RESTORECOMMAND = 2     # ADL_SDK_3.0/include/adl_defines.h:93
ADL_DL_I2C_ACTIONREAD = 1     # ADL_SDK_3.0/include/adl_defines.h:104
ADL_DL_I2C_ACTIONWRITE = 2     # ADL_SDK_3.0/include/adl_defines.h:105
ADL_DL_I2C_ACTIONREAD_REPEATEDSTART = 3     # ADL_SDK_3.0/include/adl_defines.h:106
ADL_OK_WAIT = 4     # ADL_SDK_3.0/include/adl_defines.h:122
ADL_OK_RESTART = 3     # ADL_SDK_3.0/include/adl_defines.h:125
ADL_OK_MODE_CHANGE = 2     # ADL_SDK_3.0/include/adl_defines.h:128
ADL_OK_WARNING = 1     # ADL_SDK_3.0/include/adl_defines.h:131
ADL_OK = 0     # ADL_SDK_3.0/include/adl_defines.h:134
ADL_ERR = -1     # ADL_SDK_3.0/include/adl_defines.h:137
ADL_ERR_NOT_INIT = -2     # ADL_SDK_3.0/include/adl_defines.h:140
ADL_ERR_INVALID_PARAM = -3     # ADL_SDK_3.0/include/adl_defines.h:143
ADL_ERR_INVALID_PARAM_SIZE = -4     # ADL_SDK_3.0/include/adl_defines.h:146
ADL_ERR_INVALID_ADL_IDX = -5     # ADL_SDK_3.0/include/adl_defines.h:149
ADL_ERR_INVALID_CONTROLLER_IDX = -6     # ADL_SDK_3.0/include/adl_defines.h:152
ADL_ERR_INVALID_DIPLAY_IDX = -7     # ADL_SDK_3.0/include/adl_defines.h:155
ADL_ERR_NOT_SUPPORTED = -8     # ADL_SDK_3.0/include/adl_defines.h:158
ADL_ERR_NULL_POINTER = -9     # ADL_SDK_3.0/include/adl_defines.h:161
ADL_ERR_DISABLED_ADAPTER = -10     # ADL_SDK_3.0/include/adl_defines.h:164
ADL_ERR_INVALID_CALLBACK = -11     # ADL_SDK_3.0/include/adl_defines.h:167
ADL_ERR_RESOURCE_CONFLICT = -12     # ADL_SDK_3.0/include/adl_defines.h:170
ADL_DT_MONITOR = 0     # ADL_SDK_3.0/include/adl_defines.h:185
ADL_DT_TELEVISION = 1     # ADL_SDK_3.0/include/adl_defines.h:188
ADL_DT_LCD_PANEL = 2     # ADL_SDK_3.0/include/adl_defines.h:191
ADL_DT_DIGITAL_FLAT_PANEL = 3     # ADL_SDK_3.0/include/adl_defines.h:194
ADL_DT_COMPONENT_VIDEO = 4     # ADL_SDK_3.0/include/adl_defines.h:197
ADL_DT_PROJECTOR = 5     # ADL_SDK_3.0/include/adl_defines.h:200
ADL_DOT_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:210
ADL_DOT_COMPOSITE = 1     # ADL_SDK_3.0/include/adl_defines.h:213
ADL_DOT_SVIDEO = 2     # ADL_SDK_3.0/include/adl_defines.h:216
ADL_DOT_ANALOG = 3     # ADL_SDK_3.0/include/adl_defines.h:219
ADL_DOT_DIGITAL = 4     # ADL_SDK_3.0/include/adl_defines.h:222
ADL_DISPLAY_COLOR_BRIGHTNESS = 1     # ADL_SDK_3.0/include/adl_defines.h:232
ADL_DISPLAY_COLOR_CONTRAST = 2     # ADL_SDK_3.0/include/adl_defines.h:233
ADL_DISPLAY_COLOR_SATURATION = 4     # ADL_SDK_3.0/include/adl_defines.h:234
ADL_DISPLAY_COLOR_HUE = 8     # ADL_SDK_3.0/include/adl_defines.h:235
ADL_DISPLAY_COLOR_TEMPERATURE = 16     # ADL_SDK_3.0/include/adl_defines.h:236
ADL_DISPLAY_COLOR_TEMPERATURE_SOURCE_EDID = 32     # ADL_SDK_3.0/include/adl_defines.h:240
ADL_DISPLAY_COLOR_TEMPERATURE_SOURCE_USER = 64     # ADL_SDK_3.0/include/adl_defines.h:243
ADL_DISPLAY_ADJUST_OVERSCAN = 1     # ADL_SDK_3.0/include/adl_defines.h:253
ADL_DISPLAY_ADJUST_VERT_POS = 2     # ADL_SDK_3.0/include/adl_defines.h:254
ADL_DISPLAY_ADJUST_HOR_POS = 4     # ADL_SDK_3.0/include/adl_defines.h:255
ADL_DISPLAY_ADJUST_VERT_SIZE = 8     # ADL_SDK_3.0/include/adl_defines.h:256
ADL_DISPLAY_ADJUST_HOR_SIZE = 16     # ADL_SDK_3.0/include/adl_defines.h:257
ADL_DISPLAY_ADJUST_SIZEPOS = 30     # ADL_SDK_3.0/include/adl_defines.h:258
ADL_DISPLAY_CUSTOMMODES = 32     # ADL_SDK_3.0/include/adl_defines.h:259
ADL_DISPLAY_ADJUST_UNDERSCAN = 64     # ADL_SDK_3.0/include/adl_defines.h:260
ADL_DESKTOPCONFIG_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:271
ADL_DESKTOPCONFIG_SINGLE = 1     # ADL_SDK_3.0/include/adl_defines.h:272
ADL_DESKTOPCONFIG_CLONE = 4     # ADL_SDK_3.0/include/adl_defines.h:273
ADL_DESKTOPCONFIG_BIGDESK_H = 16     # ADL_SDK_3.0/include/adl_defines.h:274
ADL_DESKTOPCONFIG_BIGDESK_V = 32     # ADL_SDK_3.0/include/adl_defines.h:275
ADL_DESKTOPCONFIG_BIGDESK_HR = 64     # ADL_SDK_3.0/include/adl_defines.h:276
ADL_DESKTOPCONFIG_BIGDESK_VR = 128     # ADL_SDK_3.0/include/adl_defines.h:277
ADL_DESKTOPCONFIG_RANDR12 = 256     # ADL_SDK_3.0/include/adl_defines.h:278
ADL_MAX_DISPLAY_NAME = 256     # ADL_SDK_3.0/include/adl_defines.h:284
ADL_DISPLAYDDCINFOEX_FLAG_PROJECTORDEVICE = 1     # ADL_SDK_3.0/include/adl_defines.h:292
ADL_DISPLAYDDCINFOEX_FLAG_EDIDEXTENSION = 2     # ADL_SDK_3.0/include/adl_defines.h:293
ADL_DISPLAYDDCINFOEX_FLAG_DIGITALDEVICE = 4     # ADL_SDK_3.0/include/adl_defines.h:294
ADL_DISPLAYDDCINFOEX_FLAG_HDMIAUDIODEVICE = 8     # ADL_SDK_3.0/include/adl_defines.h:295
ADL_DISPLAYDDCINFOEX_FLAG_SUPPORTS_AI = 16     # ADL_SDK_3.0/include/adl_defines.h:296
ADL_DISPLAYDDCINFOEX_FLAG_SUPPORT_xvYCC601 = 32     # ADL_SDK_3.0/include/adl_defines.h:297
ADL_DISPLAYDDCINFOEX_FLAG_SUPPORT_xvYCC709 = 64     # ADL_SDK_3.0/include/adl_defines.h:298
ADL_DISPLAY_CONTYPE_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:308
ADL_DISPLAY_CONTYPE_VGA = 1     # ADL_SDK_3.0/include/adl_defines.h:309
ADL_DISPLAY_CONTYPE_DVI_D = 2     # ADL_SDK_3.0/include/adl_defines.h:310
ADL_DISPLAY_CONTYPE_DVI_I = 3     # ADL_SDK_3.0/include/adl_defines.h:311
ADL_DISPLAY_CONTYPE_ATICVDONGLE_NTSC = 4     # ADL_SDK_3.0/include/adl_defines.h:312
ADL_DISPLAY_CONTYPE_ATICVDONGLE_JPN = 5     # ADL_SDK_3.0/include/adl_defines.h:313
ADL_DISPLAY_CONTYPE_ATICVDONGLE_NONI2C_JPN = 6     # ADL_SDK_3.0/include/adl_defines.h:314
ADL_DISPLAY_CONTYPE_ATICVDONGLE_NONI2C_NTSC = 7     # ADL_SDK_3.0/include/adl_defines.h:315
ADL_DISPLAY_CONTYPE_HDMI_TYPE_A = 10     # ADL_SDK_3.0/include/adl_defines.h:316
ADL_DISPLAY_CONTYPE_HDMI_TYPE_B = 11     # ADL_SDK_3.0/include/adl_defines.h:317
ADL_DISPLAY_CONTYPE_SVIDEO = 12     # ADL_SDK_3.0/include/adl_defines.h:318
ADL_DISPLAY_CONTYPE_COMPOSITE = 13     # ADL_SDK_3.0/include/adl_defines.h:319
ADL_DISPLAY_CONTYPE_RCA_3COMPONENT = 14     # ADL_SDK_3.0/include/adl_defines.h:320
ADL_DISPLAY_CONTYPE_DISPLAYPORT = 15     # ADL_SDK_3.0/include/adl_defines.h:321
ADL_TV_STANDARDS = 1     # ADL_SDK_3.0/include/adl_defines.h:331
ADL_TV_SCART = 2     # ADL_SDK_3.0/include/adl_defines.h:332
ADL_STANDARD_NTSC_M = 1     # ADL_SDK_3.0/include/adl_defines.h:336
ADL_STANDARD_NTSC_JPN = 2     # ADL_SDK_3.0/include/adl_defines.h:337
ADL_STANDARD_NTSC_N = 4     # ADL_SDK_3.0/include/adl_defines.h:338
ADL_STANDARD_PAL_B = 8     # ADL_SDK_3.0/include/adl_defines.h:339
ADL_STANDARD_PAL_COMB_N = 16     # ADL_SDK_3.0/include/adl_defines.h:340
ADL_STANDARD_PAL_D = 32     # ADL_SDK_3.0/include/adl_defines.h:341
ADL_STANDARD_PAL_G = 64     # ADL_SDK_3.0/include/adl_defines.h:342
ADL_STANDARD_PAL_H = 128     # ADL_SDK_3.0/include/adl_defines.h:343
ADL_STANDARD_PAL_I = 256     # ADL_SDK_3.0/include/adl_defines.h:344
ADL_STANDARD_PAL_K = 512     # ADL_SDK_3.0/include/adl_defines.h:345
ADL_STANDARD_PAL_K1 = 1024     # ADL_SDK_3.0/include/adl_defines.h:346
ADL_STANDARD_PAL_L = 2048     # ADL_SDK_3.0/include/adl_defines.h:347
ADL_STANDARD_PAL_M = 4096     # ADL_SDK_3.0/include/adl_defines.h:348
ADL_STANDARD_PAL_N = 8192     # ADL_SDK_3.0/include/adl_defines.h:349
ADL_STANDARD_PAL_SECAM_D = 16384     # ADL_SDK_3.0/include/adl_defines.h:350
ADL_STANDARD_PAL_SECAM_K = 32768     # ADL_SDK_3.0/include/adl_defines.h:351
ADL_STANDARD_PAL_SECAM_K1 = 65536     # ADL_SDK_3.0/include/adl_defines.h:352
ADL_STANDARD_PAL_SECAM_L = 131072     # ADL_SDK_3.0/include/adl_defines.h:353
ADL_CUSTOMIZEDMODEFLAG_MODESUPPORTED = 1     # ADL_SDK_3.0/include/adl_defines.h:364
ADL_CUSTOMIZEDMODEFLAG_NOTDELETETABLE = 2     # ADL_SDK_3.0/include/adl_defines.h:365
ADL_CUSTOMIZEDMODEFLAG_INSERTBYDRIVER = 4     # ADL_SDK_3.0/include/adl_defines.h:366
ADL_CUSTOMIZEDMODEFLAG_INTERLACED = 8     # ADL_SDK_3.0/include/adl_defines.h:367
ADL_CUSTOMIZEDMODEFLAG_BASEMODE = 16     # ADL_SDK_3.0/include/adl_defines.h:368
ADL_DISPLAYDDCINFOEX_FLAG_PROJECTORDEVICE = 1     # ADL_SDK_3.0/include/adl_defines.h:378
ADL_DISPLAYDDCINFOEX_FLAG_EDIDEXTENSION = 2     # ADL_SDK_3.0/include/adl_defines.h:379
ADL_DISPLAYDDCINFOEX_FLAG_DIGITALDEVICE = 4     # ADL_SDK_3.0/include/adl_defines.h:380
ADL_DISPLAYDDCINFOEX_FLAG_HDMIAUDIODEVICE = 8     # ADL_SDK_3.0/include/adl_defines.h:381
ADL_DISPLAYDDCINFOEX_FLAG_SUPPORTS_AI = 16     # ADL_SDK_3.0/include/adl_defines.h:382
ADL_DISPLAYDDCINFOEX_FLAG_SUPPORT_xvYCC601 = 32     # ADL_SDK_3.0/include/adl_defines.h:383
ADL_DISPLAYDDCINFOEX_FLAG_SUPPORT_xvYCC709 = 64     # ADL_SDK_3.0/include/adl_defines.h:384
ADL_DISPLAY_CV_DONGLE_D1 = 1     # ADL_SDK_3.0/include/adl_defines.h:394
ADL_DISPLAY_CV_DONGLE_D2 = 2     # ADL_SDK_3.0/include/adl_defines.h:395
ADL_DISPLAY_CV_DONGLE_D3 = 4     # ADL_SDK_3.0/include/adl_defines.h:396
ADL_DISPLAY_CV_DONGLE_D4 = 8     # ADL_SDK_3.0/include/adl_defines.h:397
ADL_DISPLAY_CV_DONGLE_D5 = 16     # ADL_SDK_3.0/include/adl_defines.h:398
ADL_DISPLAY_CV_DONGLE_480I = 1     # ADL_SDK_3.0/include/adl_defines.h:403
ADL_DISPLAY_CV_DONGLE_480P = 2     # ADL_SDK_3.0/include/adl_defines.h:404
ADL_DISPLAY_CV_DONGLE_540P = 4     # ADL_SDK_3.0/include/adl_defines.h:405
ADL_DISPLAY_CV_DONGLE_720P = 8     # ADL_SDK_3.0/include/adl_defines.h:406
ADL_DISPLAY_CV_DONGLE_1080I = 16     # ADL_SDK_3.0/include/adl_defines.h:407
ADL_DISPLAY_CV_DONGLE_1080P = 32     # ADL_SDK_3.0/include/adl_defines.h:408
ADL_DISPLAY_CV_DONGLE_16_9 = 64     # ADL_SDK_3.0/include/adl_defines.h:409
ADL_DISPLAY_CV_DONGLE_720P50 = 128     # ADL_SDK_3.0/include/adl_defines.h:410
ADL_DISPLAY_CV_DONGLE_1080I25 = 256     # ADL_SDK_3.0/include/adl_defines.h:411
ADL_DISPLAY_CV_DONGLE_576I25 = 512     # ADL_SDK_3.0/include/adl_defines.h:412
ADL_DISPLAY_CV_DONGLE_576P50 = 1024     # ADL_SDK_3.0/include/adl_defines.h:413
ADL_DISPLAY_CV_DONGLE_1080P24 = 2048     # ADL_SDK_3.0/include/adl_defines.h:414
ADL_DISPLAY_CV_DONGLE_1080P25 = 4096     # ADL_SDK_3.0/include/adl_defines.h:415
ADL_DISPLAY_CV_DONGLE_1080P30 = 8192     # ADL_SDK_3.0/include/adl_defines.h:416
ADL_DISPLAY_CV_DONGLE_1080P50 = 16384     # ADL_SDK_3.0/include/adl_defines.h:417
ADL_DISPLAY_FORMAT_FORCE_720P = 1     # ADL_SDK_3.0/include/adl_defines.h:429
ADL_DISPLAY_FORMAT_FORCE_1080I = 2     # ADL_SDK_3.0/include/adl_defines.h:430
ADL_DISPLAY_FORMAT_FORCE_1080P = 4     # ADL_SDK_3.0/include/adl_defines.h:431
ADL_DISPLAY_FORMAT_FORCE_720P50 = 8     # ADL_SDK_3.0/include/adl_defines.h:432
ADL_DISPLAY_FORMAT_FORCE_1080I25 = 16     # ADL_SDK_3.0/include/adl_defines.h:433
ADL_DISPLAY_FORMAT_FORCE_576I25 = 32     # ADL_SDK_3.0/include/adl_defines.h:434
ADL_DISPLAY_FORMAT_FORCE_576P50 = 64     # ADL_SDK_3.0/include/adl_defines.h:435
ADL_DISPLAY_FORMAT_FORCE_1080P24 = 128     # ADL_SDK_3.0/include/adl_defines.h:436
ADL_DISPLAY_FORMAT_FORCE_1080P25 = 256     # ADL_SDK_3.0/include/adl_defines.h:437
ADL_DISPLAY_FORMAT_FORCE_1080P30 = 512     # ADL_SDK_3.0/include/adl_defines.h:438
ADL_DISPLAY_FORMAT_FORCE_1080P50 = 1024     # ADL_SDK_3.0/include/adl_defines.h:439
ADL_DISPLAY_FORMAT_CVDONGLEOVERIDE = 1     # ADL_SDK_3.0/include/adl_defines.h:444
ADL_DISPLAY_FORMAT_CVMODEUNDERSCAN = 2     # ADL_SDK_3.0/include/adl_defines.h:445
ADL_DISPLAY_FORMAT_FORCECONNECT_SUPPORTED = 4     # ADL_SDK_3.0/include/adl_defines.h:446
ADL_DISPLAY_FORMAT_RESTRICT_FORMAT_SELECTION = 8     # ADL_SDK_3.0/include/adl_defines.h:447
ADL_DISPLAY_FORMAT_SETASPECRATIO = 16     # ADL_SDK_3.0/include/adl_defines.h:448
ADL_DISPLAY_FORMAT_FORCEMODES = 32     # ADL_SDK_3.0/include/adl_defines.h:449
ADL_DISPLAY_FORMAT_LCDRTCCOEFF = 64     # ADL_SDK_3.0/include/adl_defines.h:450
ADL_PM_PARAM_DONT_CHANGE = 0     # ADL_SDK_3.0/include/adl_defines.h:456
ADL_BUSTYPE_PCI = 0     # ADL_SDK_3.0/include/adl_defines.h:462
ADL_BUSTYPE_AGP = 1     # ADL_SDK_3.0/include/adl_defines.h:463
ADL_BUSTYPE_PCIE = 2     # ADL_SDK_3.0/include/adl_defines.h:464
ADL_BUSTYPE_PCIE_GEN2 = 3     # ADL_SDK_3.0/include/adl_defines.h:465
ADL_STEREO_SUPPORTED = 4     # ADL_SDK_3.0/include/adl_defines.h:478
ADL_STEREO_BLUE_LINE = 8     # ADL_SDK_3.0/include/adl_defines.h:481
ADL_STEREO_OFF = 0     # ADL_SDK_3.0/include/adl_defines.h:484
ADL_STEREO_ACTIVE = 2     # ADL_SDK_3.0/include/adl_defines.h:487
ADL_STEREO_AUTO_HORIZONTAL = 1073741824     # ADL_SDK_3.0/include/adl_defines.h:490
ADL_STEREO_AUTO_VERTICAL = 2147483648     # ADL_SDK_3.0/include/adl_defines.h:493
ADL_STEREO_PASSIVE = 64     # ADL_SDK_3.0/include/adl_defines.h:496
ADL_STEREO_PASSIVE_HORIZ = 128     # ADL_SDK_3.0/include/adl_defines.h:499
ADL_STEREO_PASSIVE_VERT = 256     # ADL_SDK_3.0/include/adl_defines.h:502
ADL_WORKSTATION_LOADBALANCING_SUPPORTED = 1     # ADL_SDK_3.0/include/adl_defines.h:507
ADL_WORKSTATION_LOADBALANCING_AVAILABLE = 2     # ADL_SDK_3.0/include/adl_defines.h:510
ADL_WORKSTATION_LOADBALANCING_DISABLED = 0     # ADL_SDK_3.0/include/adl_defines.h:514
ADL_WORKSTATION_LOADBALANCING_ENABLED = 1     # ADL_SDK_3.0/include/adl_defines.h:517
ADL_CONTEXT_SPEED_UNFORCED = 0     # ADL_SDK_3.0/include/adl_defines.h:526
ADL_CONTEXT_SPEED_FORCEHIGH = 1     # ADL_SDK_3.0/include/adl_defines.h:527
ADL_CONTEXT_SPEED_FORCELOW = 2     # ADL_SDK_3.0/include/adl_defines.h:528
ADL_ADAPTER_SPEEDCAPS_SUPPORTED = 1     # ADL_SDK_3.0/include/adl_defines.h:530
ADL_GLSYNC_PORT_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:542
ADL_GLSYNC_PORT_BNC = 1     # ADL_SDK_3.0/include/adl_defines.h:545
ADL_GLSYNC_PORT_RJ45PORT1 = 2     # ADL_SDK_3.0/include/adl_defines.h:548
ADL_GLSYNC_PORT_RJ45PORT2 = 3     # ADL_SDK_3.0/include/adl_defines.h:551
ADL_GLSYNC_CONFIGMASK_NONE = 0     # ADL_SDK_3.0/include/adl_defines.h:558
ADL_GLSYNC_CONFIGMASK_SIGNALSOURCE = 1     # ADL_SDK_3.0/include/adl_defines.h:561
ADL_GLSYNC_CONFIGMASK_SYNCFIELD = 2     # ADL_SDK_3.0/include/adl_defines.h:564
ADL_GLSYNC_CONFIGMASK_SAMPLERATE = 4     # ADL_SDK_3.0/include/adl_defines.h:567
ADL_GLSYNC_CONFIGMASK_SYNCDELAY = 8     # ADL_SDK_3.0/include/adl_defines.h:570
ADL_GLSYNC_CONFIGMASK_TRIGGEREDGE = 16     # ADL_SDK_3.0/include/adl_defines.h:573
ADL_GLSYNC_CONFIGMASK_SCANRATECOEFF = 32     # ADL_SDK_3.0/include/adl_defines.h:576
ADL_GLSYNC_CONFIGMASK_FRAMELOCKCNTL = 64     # ADL_SDK_3.0/include/adl_defines.h:579
ADL_GLSYNC_FRAMELOCKCNTL_NONE = 0     # ADL_SDK_3.0/include/adl_defines.h:587
ADL_GLSYNC_FRAMELOCKCNTL_ENABLE = 1     # ADL_SDK_3.0/include/adl_defines.h:590
ADL_GLSYNC_FRAMELOCKCNTL_DISABLE = 2     # ADL_SDK_3.0/include/adl_defines.h:592
ADL_GLSYNC_FRAMELOCKCNTL_SWAP_COUNTER_RESET = 4     # ADL_SDK_3.0/include/adl_defines.h:593
ADL_GLSYNC_FRAMELOCKCNTL_SWAP_COUNTER_ACK = 8     # ADL_SDK_3.0/include/adl_defines.h:594
ADL_GLSYNC_FRAMELOCKCNTL_STATE_ENABLE = 1     # ADL_SDK_3.0/include/adl_defines.h:596
ADL_GLSYNC_COUNTER_SWAP = 1     # ADL_SDK_3.0/include/adl_defines.h:600
ADL_GLSYNC_SIGNALSOURCE_UNDEFINED = 256     # ADL_SDK_3.0/include/adl_defines.h:607
ADL_GLSYNC_SIGNALSOURCE_FREERUN = 257     # ADL_SDK_3.0/include/adl_defines.h:610
ADL_GLSYNC_SIGNALSOURCE_BNCPORT = 258     # ADL_SDK_3.0/include/adl_defines.h:613
ADL_GLSYNC_SIGNALSOURCE_RJ45PORT1 = 259     # ADL_SDK_3.0/include/adl_defines.h:616
ADL_GLSYNC_SIGNALSOURCE_RJ45PORT2 = 260     # ADL_SDK_3.0/include/adl_defines.h:619
ADL_GLSYNC_SIGNALTYPE_UNDEFINED = 0     # ADL_SDK_3.0/include/adl_defines.h:627
ADL_GLSYNC_SIGNALTYPE_480I = 1     # ADL_SDK_3.0/include/adl_defines.h:630
ADL_GLSYNC_SIGNALTYPE_576I = 2     # ADL_SDK_3.0/include/adl_defines.h:633
ADL_GLSYNC_SIGNALTYPE_480P = 3     # ADL_SDK_3.0/include/adl_defines.h:636
ADL_GLSYNC_SIGNALTYPE_576P = 4     # ADL_SDK_3.0/include/adl_defines.h:639
ADL_GLSYNC_SIGNALTYPE_720P = 5     # ADL_SDK_3.0/include/adl_defines.h:642
ADL_GLSYNC_SIGNALTYPE_1080P = 6     # ADL_SDK_3.0/include/adl_defines.h:645
ADL_GLSYNC_SIGNALTYPE_1080I = 7     # ADL_SDK_3.0/include/adl_defines.h:648
ADL_GLSYNC_SIGNALTYPE_SDI = 8     # ADL_SDK_3.0/include/adl_defines.h:651
ADL_GLSYNC_SIGNALTYPE_TTL = 9     # ADL_SDK_3.0/include/adl_defines.h:654
ADL_GLSYNC_SIGNALTYPE_ANALOG = 10     # ADL_SDK_3.0/include/adl_defines.h:657
ADL_GLSYNC_SYNCFIELD_UNDEFINED = 0     # ADL_SDK_3.0/include/adl_defines.h:664
ADL_GLSYNC_SYNCFIELD_BOTH = 1     # ADL_SDK_3.0/include/adl_defines.h:667
ADL_GLSYNC_SYNCFIELD_1 = 2     # ADL_SDK_3.0/include/adl_defines.h:670
ADL_GLSYNC_TRIGGEREDGE_UNDEFINED = 0     # ADL_SDK_3.0/include/adl_defines.h:678
ADL_GLSYNC_TRIGGEREDGE_RISING = 1     # ADL_SDK_3.0/include/adl_defines.h:681
ADL_GLSYNC_TRIGGEREDGE_FALLING = 2     # ADL_SDK_3.0/include/adl_defines.h:684
ADL_GLSYNC_TRIGGEREDGE_BOTH = 3     # ADL_SDK_3.0/include/adl_defines.h:687
ADL_GLSYNC_SCANRATECOEFF_UNDEFINED = 0     # ADL_SDK_3.0/include/adl_defines.h:695
ADL_GLSYNC_SCANRATECOEFF_x5 = 1     # ADL_SDK_3.0/include/adl_defines.h:698
ADL_GLSYNC_SCANRATECOEFF_x4 = 2     # ADL_SDK_3.0/include/adl_defines.h:701
ADL_GLSYNC_SCANRATECOEFF_x3 = 3     # ADL_SDK_3.0/include/adl_defines.h:704
ADL_GLSYNC_SCANRATECOEFF_x5_DIV_2 = 4     # ADL_SDK_3.0/include/adl_defines.h:707
ADL_GLSYNC_SCANRATECOEFF_x2 = 5     # ADL_SDK_3.0/include/adl_defines.h:710
ADL_GLSYNC_SCANRATECOEFF_x3_DIV_2 = 6     # ADL_SDK_3.0/include/adl_defines.h:713
ADL_GLSYNC_SCANRATECOEFF_x5_DIV_4 = 7     # ADL_SDK_3.0/include/adl_defines.h:716
ADL_GLSYNC_SCANRATECOEFF_x1 = 8     # ADL_SDK_3.0/include/adl_defines.h:719
ADL_GLSYNC_SCANRATECOEFF_x4_DIV_5 = 9     # ADL_SDK_3.0/include/adl_defines.h:722
ADL_GLSYNC_SCANRATECOEFF_x2_DIV_3 = 10     # ADL_SDK_3.0/include/adl_defines.h:725
ADL_GLSYNC_SCANRATECOEFF_x1_DIV_2 = 11     # ADL_SDK_3.0/include/adl_defines.h:728
ADL_GLSYNC_SCANRATECOEFF_x2_DIV_5 = 12     # ADL_SDK_3.0/include/adl_defines.h:731
ADL_GLSYNC_SCANRATECOEFF_x1_DIV_3 = 13     # ADL_SDK_3.0/include/adl_defines.h:734
ADL_GLSYNC_SCANRATECOEFF_x1_DIV_4 = 14     # ADL_SDK_3.0/include/adl_defines.h:737
ADL_GLSYNC_SCANRATECOEFF_x1_DIV_5 = 15     # ADL_SDK_3.0/include/adl_defines.h:740
ADL_GLSYNC_PORTSTATE_UNDEFINED = 0     # ADL_SDK_3.0/include/adl_defines.h:748
ADL_GLSYNC_PORTSTATE_NOCABLE = 1     # ADL_SDK_3.0/include/adl_defines.h:751
ADL_GLSYNC_PORTSTATE_IDLE = 2     # ADL_SDK_3.0/include/adl_defines.h:754
ADL_GLSYNC_PORTSTATE_INPUT = 3     # ADL_SDK_3.0/include/adl_defines.h:757
ADL_GLSYNC_PORTSTATE_OUTPUT = 4     # ADL_SDK_3.0/include/adl_defines.h:760
ADL_GLSYNC_LEDTYPE_BNC = 0     # ADL_SDK_3.0/include/adl_defines.h:768
ADL_GLSYNC_LEDTYPE_RJ45_LEFT = 0     # ADL_SDK_3.0/include/adl_defines.h:771
ADL_GLSYNC_LEDTYPE_RJ45_RIGHT = 1     # ADL_SDK_3.0/include/adl_defines.h:774
ADL_GLSYNC_LEDCOLOR_UNDEFINED = 0     # ADL_SDK_3.0/include/adl_defines.h:782
ADL_GLSYNC_LEDCOLOR_NOLIGHT = 1     # ADL_SDK_3.0/include/adl_defines.h:785
ADL_GLSYNC_LEDCOLOR_YELLOW = 2     # ADL_SDK_3.0/include/adl_defines.h:788
ADL_GLSYNC_LEDCOLOR_RED = 3     # ADL_SDK_3.0/include/adl_defines.h:791
ADL_GLSYNC_LEDCOLOR_GREEN = 4     # ADL_SDK_3.0/include/adl_defines.h:794
ADL_GLSYNC_LEDCOLOR_FLASH_GREEN = 5     # ADL_SDK_3.0/include/adl_defines.h:797
ADL_GLSYNC_PORTCNTL_NONE = 0     # ADL_SDK_3.0/include/adl_defines.h:805
ADL_GLSYNC_PORTCNTL_OUTPUT = 1     # ADL_SDK_3.0/include/adl_defines.h:808
ADL_GLSYNC_MODECNTL_NONE = 0     # ADL_SDK_3.0/include/adl_defines.h:816
ADL_GLSYNC_MODECNTL_GENLOCK = 1     # ADL_SDK_3.0/include/adl_defines.h:819
ADL_GLSYNC_MODECNTL_TIMINGSERVER = 2     # ADL_SDK_3.0/include/adl_defines.h:822
ADL_GLSYNC_MODECNTL_STATUS_NONE = 0     # ADL_SDK_3.0/include/adl_defines.h:828
ADL_GLSYNC_MODECNTL_STATUS_GENLOCK = 1     # ADL_SDK_3.0/include/adl_defines.h:831
ADL_GLSYNC_MODECNTL_STATUS_SETMODE_REQUIRED = 2     # ADL_SDK_3.0/include/adl_defines.h:834
ADL_GLSYNC_MODECNTL_STATUS_GENLOCK_ALLOWED = 4     # ADL_SDK_3.0/include/adl_defines.h:837
ADL_MAX_GLSYNC_PORTS = 8     # ADL_SDK_3.0/include/adl_defines.h:839
ADL_MAX_GLSYNC_PORT_LEDS = 8     # ADL_SDK_3.0/include/adl_defines.h:840
ADL_XFIREX_STATE_NOINTERCONNECT = 1     # ADL_SDK_3.0/include/adl_defines.h:849
ADL_XFIREX_STATE_DOWNGRADEPIPES = 2     # ADL_SDK_3.0/include/adl_defines.h:850
ADL_XFIREX_STATE_DOWNGRADEMEM = 4     # ADL_SDK_3.0/include/adl_defines.h:851
ADL_XFIREX_STATE_REVERSERECOMMENDED = 8     # ADL_SDK_3.0/include/adl_defines.h:852
ADL_XFIREX_STATE_3DACTIVE = 16     # ADL_SDK_3.0/include/adl_defines.h:853
ADL_XFIREX_STATE_MASTERONSLAVE = 32     # ADL_SDK_3.0/include/adl_defines.h:854
ADL_XFIREX_STATE_NODISPLAYCONNECT = 64     # ADL_SDK_3.0/include/adl_defines.h:855
ADL_XFIREX_STATE_NOPRIMARYVIEW = 128     # ADL_SDK_3.0/include/adl_defines.h:856
ADL_XFIREX_STATE_DOWNGRADEVISMEM = 256     # ADL_SDK_3.0/include/adl_defines.h:857
ADL_XFIREX_STATE_LESSTHAN8LANE_MASTER = 512     # ADL_SDK_3.0/include/adl_defines.h:858
ADL_XFIREX_STATE_LESSTHAN8LANE_SLAVE = 1024     # ADL_SDK_3.0/include/adl_defines.h:859
ADL_XFIREX_STATE_PEERTOPEERFAILED = 2048     # ADL_SDK_3.0/include/adl_defines.h:860
ADL_XFIREX_STATE_MEMISDOWNGRADED = 65536     # ADL_SDK_3.0/include/adl_defines.h:861
ADL_XFIREX_STATE_PIPESDOWNGRADED = 131072     # ADL_SDK_3.0/include/adl_defines.h:862
ADL_XFIREX_STATE_XFIREXACTIVE = 262144     # ADL_SDK_3.0/include/adl_defines.h:863
ADL_XFIREX_STATE_VISMEMISDOWNGRADED = 524288     # ADL_SDK_3.0/include/adl_defines.h:864
ADL_XFIREX_STATE_INVALIDINTERCONNECTION = 1048576     # ADL_SDK_3.0/include/adl_defines.h:865
ADL_XFIREX_STATE_NONP2PMODE = 2097152     # ADL_SDK_3.0/include/adl_defines.h:866
ADL_XFIREX_STATE_DOWNGRADEMEMBANKS = 4194304     # ADL_SDK_3.0/include/adl_defines.h:867
ADL_XFIREX_STATE_MEMBANKSDOWNGRADED = 8388608     # ADL_SDK_3.0/include/adl_defines.h:868
ADL_XFIREX_STATE_DUALDISPLAYSALLOWED = 16777216     # ADL_SDK_3.0/include/adl_defines.h:869
ADL_XFIREX_STATE_P2P_APERTURE_MAPPING = 33554432     # ADL_SDK_3.0/include/adl_defines.h:870
ADL_XFIREX_STATE_P2PFLUSH_REQUIRED = 33554432     # ADL_SDK_3.0/include/adl_defines.h:871
ADL_XFIREX_STATE_XSP_CONNECTED = 67108864     # ADL_SDK_3.0/include/adl_defines.h:872
ADL_XFIREX_STATE_ENABLE_CF_REBOOT_REQUIRED = 134217728     # ADL_SDK_3.0/include/adl_defines.h:873
ADL_XFIREX_STATE_DISABLE_CF_REBOOT_REQUIRED = 268435456     # ADL_SDK_3.0/include/adl_defines.h:874
ADL_XFIREX_STATE_DRV_HANDLE_DOWNGRADE_KEY = 536870912     # ADL_SDK_3.0/include/adl_defines.h:875
ADL_XFIREX_STATE_CF_RECONFIG_REQUIRED = 1073741824     # ADL_SDK_3.0/include/adl_defines.h:876
ADL_XFIREX_STATE_ERRORGETTINGSTATUS = 2147483648     # ADL_SDK_3.0/include/adl_defines.h:877
ADL_DISPLAY_PIXELFORMAT_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:897
ADL_DISPLAY_PIXELFORMAT_RGB = 1     # ADL_SDK_3.0/include/adl_defines.h:898
ADL_DISPLAY_PIXELFORMAT_YCRCB444 = 2     # ADL_SDK_3.0/include/adl_defines.h:899
ADL_DISPLAY_PIXELFORMAT_YCRCB422 = 4     # ADL_SDK_3.0/include/adl_defines.h:901
ADL_DISPLAY_PIXELFORMAT_RGB_LIMITED_RANGE = 8     # ADL_SDK_3.0/include/adl_defines.h:903
ADL_DISPLAY_PIXELFORMAT_RGB_FULL_RANGE = 1     # ADL_SDK_3.0/include/adl_defines.h:904
ADL_DL_DISPLAYCONFIG_CONTYPE_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:915
ADL_DL_DISPLAYCONFIG_CONTYPE_CV_NONI2C_JP = 1     # ADL_SDK_3.0/include/adl_defines.h:916
ADL_DL_DISPLAYCONFIG_CONTYPE_CV_JPN = 2     # ADL_SDK_3.0/include/adl_defines.h:917
ADL_DL_DISPLAYCONFIG_CONTYPE_CV_NA = 3     # ADL_SDK_3.0/include/adl_defines.h:918
ADL_DL_DISPLAYCONFIG_CONTYPE_CV_NONI2C_NA = 4     # ADL_SDK_3.0/include/adl_defines.h:919
ADL_DL_DISPLAYCONFIG_CONTYPE_VGA = 5     # ADL_SDK_3.0/include/adl_defines.h:920
ADL_DL_DISPLAYCONFIG_CONTYPE_DVI_D = 6     # ADL_SDK_3.0/include/adl_defines.h:921
ADL_DL_DISPLAYCONFIG_CONTYPE_DVI_I = 7     # ADL_SDK_3.0/include/adl_defines.h:922
ADL_DL_DISPLAYCONFIG_CONTYPE_HDMI_TYPE_A = 8     # ADL_SDK_3.0/include/adl_defines.h:923
ADL_DL_DISPLAYCONFIG_CONTYPE_HDMI_TYPE_B = 9     # ADL_SDK_3.0/include/adl_defines.h:924
ADL_DL_DISPLAYCONFIG_CONTYPE_DISPLAYPORT = 10     # ADL_SDK_3.0/include/adl_defines.h:925
ADL_DISPLAY_DISPLAYINFO_DISPLAYCONNECTED = 1     # ADL_SDK_3.0/include/adl_defines.h:944
ADL_DISPLAY_DISPLAYINFO_DISPLAYMAPPED = 2     # ADL_SDK_3.0/include/adl_defines.h:945
ADL_DISPLAY_DISPLAYINFO_NONLOCAL = 4     # ADL_SDK_3.0/include/adl_defines.h:946
ADL_DISPLAY_DISPLAYINFO_FORCIBLESUPPORTED = 8     # ADL_SDK_3.0/include/adl_defines.h:947
ADL_DISPLAY_DISPLAYINFO_GENLOCKSUPPORTED = 16     # ADL_SDK_3.0/include/adl_defines.h:948
ADL_DISPLAY_DISPLAYINFO_MULTIVPU_SUPPORTED = 32     # ADL_SDK_3.0/include/adl_defines.h:949
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_SINGLE = 256     # ADL_SDK_3.0/include/adl_defines.h:951
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_CLONE = 512     # ADL_SDK_3.0/include/adl_defines.h:952
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_2VSTRETCH = 1024     # ADL_SDK_3.0/include/adl_defines.h:956
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_2HSTRETCH = 2048     # ADL_SDK_3.0/include/adl_defines.h:957
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_EXTENDED = 4096     # ADL_SDK_3.0/include/adl_defines.h:958
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_NSTRETCH1GPU = 65536     # ADL_SDK_3.0/include/adl_defines.h:962
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_NSTRETCHNGPU = 131072     # ADL_SDK_3.0/include/adl_defines.h:963
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_RESERVED2 = 262144     # ADL_SDK_3.0/include/adl_defines.h:964
ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_RESERVED3 = 524288     # ADL_SDK_3.0/include/adl_defines.h:965
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_NOTACTIVE = 1     # ADL_SDK_3.0/include/adl_defines.h:985
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_SINGLE = 2     # ADL_SDK_3.0/include/adl_defines.h:986
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_CLONE = 4     # ADL_SDK_3.0/include/adl_defines.h:987
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_NSTRETCH1GPU = 8     # ADL_SDK_3.0/include/adl_defines.h:988
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_NSTRETCHNGPU = 16     # ADL_SDK_3.0/include/adl_defines.h:989
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_2VSTRETCH = 32     # ADL_SDK_3.0/include/adl_defines.h:993
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_2HSTRETCH = 64     # ADL_SDK_3.0/include/adl_defines.h:994
ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_EXTENDED = 128     # ADL_SDK_3.0/include/adl_defines.h:995
ADL_ADAPTER_DISPLAYCAP_PREFERDISPLAY_SUPPORTED = 256     # ADL_SDK_3.0/include/adl_defines.h:997
ADL_ADAPTER_DISPLAYCAP_BEZEL_SUPPORTED = 512     # ADL_SDK_3.0/include/adl_defines.h:998
ADL_DISPLAY_DISPLAYMAP_MANNER_RESERVED = 1     # ADL_SDK_3.0/include/adl_defines.h:1011
ADL_DISPLAY_DISPLAYMAP_MANNER_NOTACTIVE = 2     # ADL_SDK_3.0/include/adl_defines.h:1012
ADL_DISPLAY_DISPLAYMAP_MANNER_SINGLE = 4     # ADL_SDK_3.0/include/adl_defines.h:1013
ADL_DISPLAY_DISPLAYMAP_MANNER_CLONE = 8     # ADL_SDK_3.0/include/adl_defines.h:1014
ADL_DISPLAY_DISPLAYMAP_MANNER_RESERVED1 = 16     # ADL_SDK_3.0/include/adl_defines.h:1015
ADL_DISPLAY_DISPLAYMAP_MANNER_HSTRETCH = 32     # ADL_SDK_3.0/include/adl_defines.h:1017
ADL_DISPLAY_DISPLAYMAP_MANNER_VSTRETCH = 64     # ADL_SDK_3.0/include/adl_defines.h:1018
ADL_DISPLAY_DISPLAYMAP_MANNER_VLD = 128     # ADL_SDK_3.0/include/adl_defines.h:1019
ADL_DISPLAY_DISPLAYMAP_OPTION_GPUINFO = 1     # ADL_SDK_3.0/include/adl_defines.h:1034
ADL_DISPLAY_DISPLAYTARGET_PREFERRED = 1     # ADL_SDK_3.0/include/adl_defines.h:1046
ADL_DISPLAY_POSSIBLEMAPRESULT_VALID = 1     # ADL_SDK_3.0/include/adl_defines.h:1058
ADL_DISPLAY_POSSIBLEMAPRESULT_BEZELSUPPORTED = 2     # ADL_SDK_3.0/include/adl_defines.h:1059
ADL_DISPLAY_MODE_COLOURFORMAT_565 = 1     # ADL_SDK_3.0/include/adl_defines.h:1076
ADL_DISPLAY_MODE_COLOURFORMAT_8888 = 2     # ADL_SDK_3.0/include/adl_defines.h:1077
ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_000 = 4     # ADL_SDK_3.0/include/adl_defines.h:1078
ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_090 = 8     # ADL_SDK_3.0/include/adl_defines.h:1079
ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_180 = 16     # ADL_SDK_3.0/include/adl_defines.h:1080
ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_270 = 32     # ADL_SDK_3.0/include/adl_defines.h:1081
ADL_DISPLAY_MODE_REFRESHRATE_ROUNDED = 64     # ADL_SDK_3.0/include/adl_defines.h:1082
ADL_DISPLAY_MODE_REFRESHRATE_ONLY = 128     # ADL_SDK_3.0/include/adl_defines.h:1083
ADL_DISPLAY_MODE_PROGRESSIVE_FLAG = 0     # ADL_SDK_3.0/include/adl_defines.h:1085
ADL_DISPLAY_MODE_INTERLACED_FLAG = 2     # ADL_SDK_3.0/include/adl_defines.h:1086
ADL_OSMODEINFOXPOS_DEFAULT = -640     # ADL_SDK_3.0/include/adl_defines.h:1100
ADL_OSMODEINFOYPOS_DEFAULT = 0     # ADL_SDK_3.0/include/adl_defines.h:1101
ADL_OSMODEINFOXRES_DEFAULT = 640     # ADL_SDK_3.0/include/adl_defines.h:1102
ADL_OSMODEINFOYRES_DEFAULT = 480     # ADL_SDK_3.0/include/adl_defines.h:1103
ADL_OSMODEINFOXRES_DEFAULT800 = 800     # ADL_SDK_3.0/include/adl_defines.h:1104
ADL_OSMODEINFOYRES_DEFAULT600 = 600     # ADL_SDK_3.0/include/adl_defines.h:1105
ADL_OSMODEINFOREFRESHRATE_DEFAULT = 60     # ADL_SDK_3.0/include/adl_defines.h:1106
ADL_OSMODEINFOCOLOURDEPTH_DEFAULT = 8     # ADL_SDK_3.0/include/adl_defines.h:1107
ADL_OSMODEINFOCOLOURDEPTH_DEFAULT16 = 16     # ADL_SDK_3.0/include/adl_defines.h:1108
ADL_OSMODEINFOCOLOURDEPTH_DEFAULT24 = 24     # ADL_SDK_3.0/include/adl_defines.h:1109
ADL_OSMODEINFOCOLOURDEPTH_DEFAULT32 = 32     # ADL_SDK_3.0/include/adl_defines.h:1110
ADL_OSMODEINFOORIENTATION_DEFAULT = 0     # ADL_SDK_3.0/include/adl_defines.h:1111
ADL_OSMODEFLAG_DEFAULT = 0     # ADL_SDK_3.0/include/adl_defines.h:1113
ADL_I2C_MAJOR_API_REV = 1     # ADL_SDK_3.0/include/adl_defines.h:1193
ADL_I2C_MINOR_DEFAULT_API_REV = 0     # ADL_SDK_3.0/include/adl_defines.h:1194
ADL_I2C_MINOR_OEM_API_REV = 1     # ADL_SDK_3.0/include/adl_defines.h:1195
ADL_DL_I2C_LINE_OEM = 1     # ADL_SDK_3.0/include/adl_defines.h:1199
ADL_DL_I2C_LINE_OD_CONTROL = 2     # ADL_SDK_3.0/include/adl_defines.h:1200
ADL_DL_I2C_LINE_OEM2 = 3     # ADL_SDK_3.0/include/adl_defines.h:1201
ADL_DL_I2C_MAXDATASIZE = 64     # ADL_SDK_3.0/include/adl_defines.h:1205
ADL_DL_I2C_MAXWRITEDATASIZE = 12     # ADL_SDK_3.0/include/adl_defines.h:1206
ADL_DL_I2C_MAXADDRESSLENGTH = 6     # ADL_SDK_3.0/include/adl_defines.h:1207
ADL_DL_I2C_MAXOFFSETLENGTH = 4     # ADL_SDK_3.0/include/adl_defines.h:1208
ADL_DL_DISPLAYPROPERTY_TYPE_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:1213
ADL_DL_DISPLAYPROPERTY_TYPE_EXPANSIONMODE = 1     # ADL_SDK_3.0/include/adl_defines.h:1214
ADL_DL_DISPLAYPROPERTY_TYPE_USEUNDERSCANSCALING = 2     # ADL_SDK_3.0/include/adl_defines.h:1215
ADL_DL_DISPLAYPROPERTY_EXPANSIONMODE_CENTER = 0     # ADL_SDK_3.0/include/adl_defines.h:1219
ADL_DL_DISPLAYPROPERTY_EXPANSIONMODE_FULLSCREEN = 1     # ADL_SDK_3.0/include/adl_defines.h:1220
ADL_DL_DISPLAYPROPERTY_EXPANSIONMODE_ASPECTRATIO = 2     # ADL_SDK_3.0/include/adl_defines.h:1221
ADL_DL_DISPLAY_DITHER_UNKNOWN = 0     # ADL_SDK_3.0/include/adl_defines.h:1225
ADL_DL_DISPLAY_DITHER_DISABLED = 1     # ADL_SDK_3.0/include/adl_defines.h:1226
ADL_DL_DISPLAY_DITHER_ENABLED = 2     # ADL_SDK_3.0/include/adl_defines.h:1227
ADL_MAX_EDIDDATA_SIZE = 256     # ADL_SDK_3.0/include/adl_defines.h:1231
ADL_MAX_EDID_EXTENSION_BLOCKS = 3     # ADL_SDK_3.0/include/adl_defines.h:1233
ADL_DL_CONTROLLER_OVERLAY_ALPHA = 0     # ADL_SDK_3.0/include/adl_defines.h:1235
ADL_DL_CONTROLLER_OVERLAY_ALPHAPERPIX = 1     # ADL_SDK_3.0/include/adl_defines.h:1236
ADL_DL_DISPLAY_DATA_PACKET__INFO_PACKET_RESET = 0     # ADL_SDK_3.0/include/adl_defines.h:1238
ADL_DL_DISPLAY_DATA_PACKET__INFO_PACKET_SET = 1     # ADL_SDK_3.0/include/adl_defines.h:1239
ADL_DL_DISPLAY_DATA_PACKET__TYPE__AVI = 1     # ADL_SDK_3.0/include/adl_defines.h:1245
ADL_DL_DISPLAY_DATA_PACKET__TYPE__RESERVED = 2     # ADL_SDK_3.0/include/adl_defines.h:1246
ADL_DL_DISPLAY_DATA_PACKET__TYPE__VENDORINFO = 4     # ADL_SDK_3.0/include/adl_defines.h:1247
ADL_GAMUT_MATRIX_SD = 1     # ADL_SDK_3.0/include/adl_defines.h:1253
ADL_GAMUT_MATRIX_HD = 2     # ADL_SDK_3.0/include/adl_defines.h:1255
ADL_DL_CLOCKINFO_FLAG_FULLSCREEN3DONLY = 1     # ADL_SDK_3.0/include/adl_defines.h:1264
ADL_DL_CLOCKINFO_FLAG_ALWAYSFULLSCREEN3D = 2     # ADL_SDK_3.0/include/adl_defines.h:1265
ADL_DL_CLOCKINFO_FLAG_VPURECOVERYREDUCED = 4     # ADL_SDK_3.0/include/adl_defines.h:1266
ADL_DL_CLOCKINFO_FLAG_THERMALPROTECTION = 8     # ADL_SDK_3.0/include/adl_defines.h:1267
ADL_DL_POWERXPRESS_GPU_INTEGRATED = 1     # ADL_SDK_3.0/include/adl_defines.h:1275
ADL_DL_POWERXPRESS_GPU_DISCRETE = 2     # ADL_SDK_3.0/include/adl_defines.h:1276
ADL_DL_POWERXPRESS_SWITCH_RESULT_STARTED = 1     # ADL_SDK_3.0/include/adl_defines.h:1282
ADL_DL_POWERXPRESS_SWITCH_RESULT_DECLINED = 2     # ADL_SDK_3.0/include/adl_defines.h:1284
ADL_DL_POWERXPRESS_SWITCH_RESULT_ALREADY = 3     # ADL_SDK_3.0/include/adl_defines.h:1286
ADL_DL_POWERXPRESS_VERSION_MAJOR = 2     # ADL_SDK_3.0/include/adl_defines.h:1293
ADL_DL_POWERXPRESS_VERSION_MINOR = 0     # ADL_SDK_3.0/include/adl_defines.h:1295
ADL_DL_POWERXPRESS_VERSION = 131072     # ADL_SDK_3.0/include/adl_defines.h:1297
ADL_DL_THERMAL_DOMAIN_OTHER = 0     # ADL_SDK_3.0/include/adl_defines.h:1301
ADL_DL_THERMAL_DOMAIN_GPU = 1     # ADL_SDK_3.0/include/adl_defines.h:1302
ADL_DL_THERMAL_FLAG_INTERRUPT = 1     # ADL_SDK_3.0/include/adl_defines.h:1306
ADL_DL_THERMAL_FLAG_FANCONTROL = 2     # ADL_SDK_3.0/include/adl_defines.h:1307
ADL_DL_FANCTRL_SUPPORTS_PERCENT_READ = 1     # ADL_SDK_3.0/include/adl_defines.h:1315
ADL_DL_FANCTRL_SUPPORTS_PERCENT_WRITE = 2     # ADL_SDK_3.0/include/adl_defines.h:1316
ADL_DL_FANCTRL_SUPPORTS_RPM_READ = 4     # ADL_SDK_3.0/include/adl_defines.h:1317
ADL_DL_FANCTRL_SUPPORTS_RPM_WRITE = 8     # ADL_SDK_3.0/include/adl_defines.h:1318
ADL_DL_FANCTRL_SPEED_TYPE_PERCENT = 1     # ADL_SDK_3.0/include/adl_defines.h:1324
ADL_DL_FANCTRL_SPEED_TYPE_RPM = 2     # ADL_SDK_3.0/include/adl_defines.h:1325
ADL_DL_FANCTRL_FLAG_USER_DEFINED_SPEED = 1     # ADL_SDK_3.0/include/adl_defines.h:1329
ADL_DL_MAX_MVPU_ADAPTERS = 4     # ADL_SDK_3.0/include/adl_defines.h:1333
MVPU_ADAPTER_0 = 1     # ADL_SDK_3.0/include/adl_defines.h:1334
MVPU_ADAPTER_1 = 2     # ADL_SDK_3.0/include/adl_defines.h:1335
MVPU_ADAPTER_2 = 4     # ADL_SDK_3.0/include/adl_defines.h:1336
MVPU_ADAPTER_3 = 8     # ADL_SDK_3.0/include/adl_defines.h:1337
ADL_DL_MAX_REGISTRY_PATH = 256     # ADL_SDK_3.0/include/adl_defines.h:1338
ADL_DL_MVPU_STATUS_OFF = 0     # ADL_SDK_3.0/include/adl_defines.h:1342
ADL_DL_MVPU_STATUS_ON = 1     # ADL_SDK_3.0/include/adl_defines.h:1343
ADL_ASIC_UNDEFINED = 0     # ADL_SDK_3.0/include/adl_defines.h:1353
ADL_ASIC_DISCRETE = 1     # ADL_SDK_3.0/include/adl_defines.h:1354
ADL_ASIC_INTEGRATED = 2     # ADL_SDK_3.0/include/adl_defines.h:1355
ADL_ASIC_FIREGL = 4     # ADL_SDK_3.0/include/adl_defines.h:1356
ADL_ASIC_FIREMV = 8     # ADL_SDK_3.0/include/adl_defines.h:1357
ADL_ASIC_XGP = 16     # ADL_SDK_3.0/include/adl_defines.h:1358
ADL_ASIC_FUSION = 32     # ADL_SDK_3.0/include/adl_defines.h:1359
ADL_DL_TIMINGFLAG_DOUBLE_SCAN = 1     # ADL_SDK_3.0/include/adl_defines.h:1369
ADL_DL_TIMINGFLAG_INTERLACED = 2     # ADL_SDK_3.0/include/adl_defines.h:1370
ADL_DL_TIMINGFLAG_H_SYNC_POLARITY = 4     # ADL_SDK_3.0/include/adl_defines.h:1371
ADL_DL_TIMINGFLAG_V_SYNC_POLARITY = 8     # ADL_SDK_3.0/include/adl_defines.h:1372
ADL_DL_MODETIMING_STANDARD_CVT = 1     # ADL_SDK_3.0/include/adl_defines.h:1382
ADL_DL_MODETIMING_STANDARD_GTF = 2     # ADL_SDK_3.0/include/adl_defines.h:1384
ADL_DL_MODETIMING_STANDARD_DMT = 4     # ADL_SDK_3.0/include/adl_defines.h:1386
ADL_DL_MODETIMING_STANDARD_CUSTOM = 8     # ADL_SDK_3.0/include/adl_defines.h:1388
ADL_DL_MODETIMING_STANDARD_DRIVER_DEFAULT = 16     # ADL_SDK_3.0/include/adl_defines.h:1390
ADL_XSERVERINFO_XINERAMAACTIVE = 1     # ADL_SDK_3.0/include/adl_defines.h:1406
ADL_XSERVERINFO_RANDR12SUPPORTED = 2     # ADL_SDK_3.0/include/adl_defines.h:1412
ADL_CONTROLLERVECTOR_0 = 1     # ADL_SDK_3.0/include/adl_defines.h:1422
ADL_CONTROLLERVECTOR_1 = 2     # ADL_SDK_3.0/include/adl_defines.h:1424
ADL_DISPLAY_SLSGRID_ORIENTATION_000 = 1     # ADL_SDK_3.0/include/adl_defines.h:1427
ADL_DISPLAY_SLSGRID_ORIENTATION_090 = 2     # ADL_SDK_3.0/include/adl_defines.h:1428
ADL_DISPLAY_SLSGRID_ORIENTATION_180 = 4     # ADL_SDK_3.0/include/adl_defines.h:1429
ADL_DISPLAY_SLSGRID_ORIENTATION_270 = 8     # ADL_SDK_3.0/include/adl_defines.h:1430
ADL_DISPLAY_SLSGRID_CAP_OPTION_RELATIVETO_LANDSCAPE = 1     # ADL_SDK_3.0/include/adl_defines.h:1431
ADL_DISPLAY_SLSGRID_CAP_OPTION_RELATIVETO_CURRENTANGLE = 2     # ADL_SDK_3.0/include/adl_defines.h:1432
ADL_DISPLAY_SLSGRID_PORTAIT_MODE = 4     # ADL_SDK_3.0/include/adl_defines.h:1433
ADL_DISPLAY_SLSMAPCONFIG_GET_OPTION_RELATIVETO_LANDSCAPE = 1     # ADL_SDK_3.0/include/adl_defines.h:1436
ADL_DISPLAY_SLSMAPCONFIG_GET_OPTION_RELATIVETO_CURRENTANGLE = 2     # ADL_SDK_3.0/include/adl_defines.h:1437
ADL_DISPLAY_SLSMAPCONFIG_CREATE_OPTION_RELATIVETO_LANDSCAPE = 1     # ADL_SDK_3.0/include/adl_defines.h:1439
ADL_DISPLAY_SLSMAPCONFIG_CREATE_OPTION_RELATIVETO_CURRENTANGLE = 2     # ADL_SDK_3.0/include/adl_defines.h:1440
ADL_DISPLAY_SLSMAPCONFIG_REARRANGE_OPTION_RELATIVETO_LANDSCAPE = 1     # ADL_SDK_3.0/include/adl_defines.h:1442
ADL_DISPLAY_SLSMAPCONFIG_REARRANGE_OPTION_RELATIVETO_CURRENTANGLE = 2     # ADL_SDK_3.0/include/adl_defines.h:1443
ADL_DISPLAY_SLSGRID_RELATIVETO_LANDSCAPE = 16     # ADL_SDK_3.0/include/adl_defines.h:1446
ADL_DISPLAY_SLSGRID_RELATIVETO_CURRENTANGLE = 32     # ADL_SDK_3.0/include/adl_defines.h:1447
ADL_DISPLAY_SLSMAP_BEZELMODE = 16     # ADL_SDK_3.0/include/adl_defines.h:1452
ADL_DISPLAY_SLSMAP_DISPLAYARRANGED = 2     # ADL_SDK_3.0/include/adl_defines.h:1455
ADL_DISPLAY_SLSMAP_CURRENTCONFIG = 4     # ADL_SDK_3.0/include/adl_defines.h:1458
ADL_DISPLAY_SLSMAPINDEXLIST_OPTION_ACTIVE = 1     # ADL_SDK_3.0/include/adl_defines.h:1462
ADL_DISPLAY_BEZELOFFSET_STEPBYSTEPSET = 4     # ADL_SDK_3.0/include/adl_defines.h:1466
ADL_DISPLAY_BEZELOFFSET_COMMIT = 8     # ADL_SDK_3.0/include/adl_defines.h:1467

# http://forums.amd.com/forum/messageview.cfm?catid=347&threadid=144777
ADL_DL_I2C_LINE_OEM=0x00000001
ADL_DL_I2C_LINE_OD_CONTROL=0x00000002
ADL_DL_I2C_LINE_OEM2=0x00000003
