"""
AUTHOR: Artur Barseghyan
    (artur.barseghyan@gmail.com)
DESCRIPTION
    Facebook-like timeline for Django admin.
"""

import os
from setuptools import setup, find_packages

try:
    readme = open(os.path.join(os.path.dirname(__file__), 'readme.rst')).read()
except:
    readme = ''

version = '0.4'

setup(
    name='admin-timeline',
    version=version,
    description=("Facebook-like timeline for Django admin"),
    long_description = readme,
    classifiers=[
        "Framework :: Django",
        "Programming Language :: Python",
        "Environment :: Web Environment",
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
    ],
    keywords='django-admin-timeline, django, app, python',
    author='Artur Barseghyan',
    author_email='artur.barseghyan@gmail.com',
    url='https://bitbucket.org/barseghyanartur/django-admin-timeline',
    package_dir={'':'src'},
    packages=find_packages(where='./src'),
    license='GPL 2.0/LGPL 2.1',
    #download_url='https://bitbucket.org/barseghyanartur/django-admin-timeline/get/%s.tar.gz' % version
)
