# rlib/console.py
#
#

""" bigO console bot. """


## =======
## IMPORTS
## =======

## rlib imports

from rlib import Bot, Event, error
from rlib import colors
from rlib.log import datefmt

## basic imports

import logging
import time
import sys
import os

## ===========
## CONSOLE BOT
## ===========

## CONSOLE event

class CONSOLE(Event): pass

## Console class

class ConsoleBot(Bot):

    def _raw(self, txt): sys.stdout.write(str(txt)) ; sys.stdout.write("\n")

    def say(self, *args, **kwargs):
        channel = args[0]
        try: txt = args[1]
        except IndexError: txt = channel
        self._raw(txt)

    def get_one(self): return CONSOLE(txt=input("%s -=- %s%s<%s " % (time.strftime(datefmt), colors.BOLD, colors.YELLOW, colors.ENDC)))
