# rlib/plugs/start.py
#
#

""" start various bots. """

## rlib imports

from rlib import cmnds, fleet, Config

## basic imports

import _thread

## default config 

xconfig = Config()
xconfig.server = "irc.xs4all.nl"
xconfig.port = 6667
xconfig.nick = "reppa"
xconfig.username = "Reppa Bot"

## xmpp config 

config = Config()
config.server = "localhost"
config.port = 5222
config.nick = "reppa"
config.username = "Reppa Bot"

## z config 

zconfig = Config()
zconfig.server = "localhost"
zconfig.port = 6667
zconfig.nick = "reppa"
zconfig.username = "Reppa Bot"
zconfig.channel = "#test"

## start command

def start(event):
    if not event.args: event.reply("start what?") ; return
    type = event.args[0]
    if type == "irc":
        from rlib.drivers.irc import IRCBot
        bot = IRCBot(**zconfig)
    elif type == "ircnet":
        from rlib.drivers.irc import IRCBot
        bot = IRCBot(**config)
    elif type == "xmpp":
        from rlib.drivers.xmpp import XMPPBot
        config.user = config.user or "feedbackflow@gmail.com"
        config.server = config.server or "talk.google.com"   
        config.port = 5222
        bot = XMPPBot(**xconfig)
    elif type == "local":
        from rlib.drivers.xmpp import XMPPBot
        config.user = config.user or  "test@localhost"
        bot = XMPPBot(**config)
    else: event.reply("no %s type bot available." % type) ; return
    fleet.register(type, bot)
    try: _thread.start_new_thread(bot.run_forever, ())
    except: error()
    fleet.bots.append(bot)

cmnds.register("start", start)
