from distutils.core import setup

try:
    # Use pypandoc to convert markdown readme to reStructuredText as required by pypi
    # Requires pandoc to be installed.  See: http://johnmacfarlane.net/pandoc/installing.html
    from pypandoc import convert
    read_md = lambda f: convert(f, 'rst', format='md')
except ImportError:
    print("warning: pypandoc module not found, could not convert Markdown to RST")
    read_md = lambda f: open(f, 'r').read()

setup(
    name='ags_tool_deploy',
    version='0.1',
    description='Provides packaging and publishing tools for ArcGIS python toolboxes',
    long_description=read_md('README.md'),
    packages=['ags_tool_deploy'],
    requires=['lxml', 'click'],
    url='https://bitbucket.org/databasin/ags_tool_deploy',
    license='BSD',
    author='Data Basin',
    author_email='databasin@consbio.org',
    keywords='arcgis ags'
)
