import aiotest


class CallbackTests(aiotest.TestCase):
    def create_hello_function(self):
        if hasattr(self.config.asyncio, 'From'):
            def hello_world(asyncio, result, delay):
                result.append("Hello")
                # retrieve the event loop from the policy
                yield asyncio.From(asyncio.sleep(delay))
                result.append('World')
                raise asyncio.Return(".")
            return hello_world
        else:
            ns = {}
            exec('''if 1:
                def hello_world(asyncio, result, delay):
                    result.append("Hello")
                    # retrieve the event loop from the policy
                    yield from asyncio.sleep(delay)
                    result.append('World')
                    return "."
            ''', ns, ns)
            return ns['hello_world']


    def test_hello_world(self):
        result = []
        hello_world = self.create_hello_function()
        coro = hello_world(self.config.asyncio, result, 0.001)
        self.loop.run_until_complete(coro)
        self.assertEqual(result, ['Hello', 'World'])

    def test_waiter(self):
        if hasattr(self.config.asyncio, 'From'):
            def waiter(trollius, hello_world, result):
                loop = trollius.get_event_loop()
                fut = trollius.Future(loop=loop)
                loop.call_soon(fut.set_result, "Future")

                value = yield trollius.From(fut)
                result.append(value)

                value = yield trollius.From(hello_world(trollius, result, 0.001))
                result.append(value)
        else:
            ns = {}
            exec('''if 1:
                def waiter(asyncio, hello_world, result):
                    loop = asyncio.get_event_loop()
                    fut = asyncio.Future(loop=loop)
                    loop.call_soon(fut.set_result, "Future")

                    value = yield from fut
                    result.append(value)

                    value = yield from hello_world(asyncio, result, 0.001)
                    result.append(value)
            ''', ns, ns)
            waiter = ns['waiter']

        result = []
        hello_world = self.create_hello_function()
        coro = waiter(self.config.asyncio, hello_world, result)
        self.loop.run_until_complete(coro)
        self.assertEqual(result, ['Future', 'Hello', 'World', '.'])


if __name__ == '__main__':
    import unittest
    unittest.main()
