# Release procedure:
#  - fill the changelog in README
#  - run tests: type "tox"
#  - update the version in setup.py to X.Y
#  - set release date in README
#  - check that "python setup.py sdist" contains all files tracked by
#    the SCM (Mercurial): update MANIFEST.in if needed
#  - hg ci
#  - hg tag X.Y
#  - hg push
#  - python setup.py sdist bdist_wheel register upload
#  - increment version in setup.py
#  - hg ci && hg push

import sys
try:
    from setuptools import setup
    SETUPTOOLS = True
except ImportError:
    SETUPTOOLS = False
    # Use distutils.core as a fallback.
    # We won't be able to build the Wheel file on Windows.
    from distutils.core import setup

with open("README") as fp:
    long_description = fp.read()

install_options = {
    "name": "aiotest",
    "version": "0.2",
    "license": "Apache License 2.0",
    "author": 'Victor Stinner',
    "author_email": 'victor.stinner@gmail.com',

    "description": "test suite to validate an implementation of the asyncio API, the PEP 3156",
    "long_description": long_description,
    "url": "https://pypi.python.org/pypi/aiotest",

    "classifiers": [
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Apache Software License",
    ],

    "packages": ["aiotest"],
}

setup(**install_options)
