#!/usr/bin/env python3
import subprocess
import sys
import textwrap

python3 = sys.executable

def run(*args):
    print("+ %s" % ' '.join(map(repr, args)))
    exitcode = subprocess.call(args)
    if exitcode:
        sys.exit(exitcode)

code = textwrap.dedent("""
    import aiotest.run
    import asyncio

    config = aiotest.TestConfig()
    config.asyncio = asyncio
    config.new_event_pool_policy = asyncio.DefaultEventLoopPolicy
    aiotest.run.main(config)
""").strip()
code = '; '.join(filter(bool, code.splitlines()))
run(python3, '-c', code)
