#!/usr/bin/env python
import subprocess
import sys
import textwrap

python = sys.executable

def run(*args):
    print("+ %s" % ' '.join(args))
    exitcode = subprocess.call(args)
    if exitcode:
        sys.exit(exitcode)

code = textwrap.dedent("""
    import aiotest.run
    import trollius

    config = aiotest.TestConfig()
    config.asyncio = trollius
    config.new_event_pool_policy = trollius.DefaultEventLoopPolicy
    aiotest.run.main(config)
""").strip()
code = '; '.join(filter(bool, code.splitlines()))
run(python, '-c', code)
