#! /usr/bin/env python

import aipy as a, numpy as n

x,y,z = n.array([1,0,0]), n.array([0,1,0]), n.array([0,0,1])
freqs = n.array([.15, .16, .17])

a7 = a.healpix.Alm(8,8)
a7.set_data(n.array(
[  6.98051544e+09 +0.00000000e+00j,  2.82893186e+09 +0.00000000e+00j,
   1.55273992e+06 +5.86086478e+06j, -1.51686473e+10 +0.00000000e+00j,
   4.29431003e+06 -4.76921865e+07j,  1.65104603e+10 +3.36880408e+06j,
  -2.70635385e+09 +0.00000000e+00j, -1.59530157e+06 -3.35669565e+07j,
   1.65542645e+10 +7.62929475e+04j,  1.35461994e+06 -5.61198389e+06j,
   5.21289243e+09 +0.00000000e+00j, -3.70450904e+06 -2.14468847e+07j,
  -5.46775266e+08 +9.90035924e+03j,  4.46930997e+06 -1.59209464e+07j,
   2.90961381e+09 -8.96788413e+05j, -4.50796690e+09 +0.00000000e+00j,
  -1.60402256e+06 +8.05175373e+06j,  7.70913557e+09 -3.89929759e+05j,
  -2.22619621e+06 +1.08224514e+07j, -1.15771838e+10 -3.61771763e+05j,
   7.93842513e+06 -2.17040957e+06j, -3.24580514e+09 +0.00000000e+00j,
  -3.39496534e+04 -1.80577420e+06j, -4.33847984e+09 -9.55258916e+05j,
  -3.87468565e+06 +2.81306937e+07j, -3.63376370e+09 +2.42109675e+06j,
   1.02194050e+07 +7.57269454e+06j,  2.89522031e+10 +3.08977255e+06j,
  -9.92029693e+09 +0.00000000e+00j,  4.68934495e+06 -1.71254169e+07j,
   2.92041123e+08 +7.30519316e+04j, -1.77882705e+06 +6.73225843e+06j,
   8.97060267e+09 -1.16111746e+06j,  7.87735397e+06 -3.50888334e+07j,
   1.36777154e+10 -5.10931439e+05j, -2.83508055e+06 +2.06890899e+07j,
   2.74925982e+09 +0.00000000e+00j, -1.11954935e+06 -6.89034340e+06j,
  -4.94195592e+09 +9.94815816e+05j,  1.45457112e+06 -2.22520429e+06j,
  -4.64082275e+08 -1.93370670e+05j,  2.64819436e+06 +2.44197810e+06j,
   6.71268475e+09 -4.73549942e+06j, -2.74252962e+06 +2.94188385e+06j,
   8.14835523e+09 +2.78935944e+06j]))
a6 = a.healpix.Alm(8,8)
a6.set_data(n.array(
[ -7.08058858e+09 +0.00000000e+00j, -2.63076659e+09 +0.00000000e+00j,
  -1.71991988e+06 -9.09608561e+06j,  1.55336230e+10 +0.00000000e+00j,
  -4.46490297e+06 +4.52469885e+07j, -1.66896426e+10 -3.42834085e+06j,
   2.02659228e+09 +0.00000000e+00j,  1.76993724e+06 +3.20346128e+07j,
  -1.65084436e+10 -6.57717644e+04j, -1.37989131e+06 +5.69415991e+06j,
  -5.76259411e+09 +0.00000000e+00j,  3.84074852e+06 +2.08608376e+07j,
   1.47984340e+08 -1.05796282e+03j, -4.58274277e+06 +1.63241521e+07j,
  -2.56918999e+09 +8.76938779e+05j,  4.38535178e+09 +0.00000000e+00j,
   1.69271675e+06 -8.76664481e+06j, -8.12359545e+09 +4.16208798e+05j,
   2.26871841e+06 -1.05483286e+07j,  1.21037664e+10 +3.46542363e+05j,
  -8.16487598e+06 +1.91149885e+06j,  3.27769310e+09 +0.00000000e+00j,
   3.10538482e+04 +1.29517389e+06j,  4.39452876e+09 +9.60228386e+05j,
   3.80150645e+06 -2.81913560e+07j,  3.60537290e+09 -2.47812561e+06j,
  -1.03534171e+07 -7.58377501e+06j, -2.95776656e+10 -3.11907038e+06j,
   1.01160754e+10 +0.00000000e+00j, -4.77022763e+06 +1.68568122e+07j,
  -3.85849221e+08 -7.38792083e+04j,  1.78893569e+06 -6.62361519e+06j,
  -9.06167000e+09 +1.22681958e+06j, -7.97594453e+06 +3.48403730e+07j,
  -1.37866332e+10 +5.32766855e+05j,  2.82122918e+06 -2.13478203e+07j,
  -2.84122026e+09 +0.00000000e+00j,  1.18359630e+06 +6.83024039e+06j,
   5.04099585e+09 -1.01528622e+06j, -1.52136138e+06 +2.37868829e+06j,
   5.10542216e+08 +1.82077509e+05j, -2.68052996e+06 -2.33166264e+06j,
  -6.86132262e+09 +4.80838252e+06j,  2.71601130e+06 -2.25714830e+06j,
  -8.39227227e+09 -2.82552362e+06j]))
a5 = a.healpix.Alm(8,8)
a5.set_data(n.array(
[  3.05285923e+09 +0.00000000e+00j,  1.03540120e+09 +0.00000000e+00j,
   8.08307739e+05 +5.24527541e+06j, -6.77384027e+09 +0.00000000e+00j,
   1.97841300e+06 -1.82770586e+07j,  7.19519292e+09 +1.48786068e+06j,
  -5.55173243e+08 +0.00000000e+00j, -8.32664373e+05 -1.30310688e+07j,
   7.01490097e+09 +2.27631032e+04j,  5.98564620e+05 -2.46425914e+06j,
   2.70319925e+09 +0.00000000e+00j, -1.69640076e+06 -8.66381843e+06j,
   1.17247339e+08 -3.29019908e+03j,  2.00297760e+06 -7.13778146e+06j,
   9.44795358e+08 -3.65299770e+05j, -1.81243678e+09 +0.00000000e+00j,
  -7.59885081e+05 +4.03782682e+06j,  3.64808420e+09 -1.89048800e+05j,
  -9.86251036e+05 +4.38825513e+06j, -5.39174660e+09 -1.41129682e+05j,
   3.58120965e+06 -7.13837941e+05j, -1.41027425e+09 +0.00000000e+00j,
  -1.14471360e+04 -3.38280934e+05j, -1.89712020e+09 -4.11983792e+05j,
  -1.58837112e+06 +1.20512692e+07j, -1.52146473e+09 +1.08194967e+06j,
   4.47350321e+06 +3.23695070e+06j,  1.28834819e+10 +1.34331658e+06j,
  -4.39992232e+09 +0.00000000e+00j,  2.06968792e+06 -7.07943263e+06j,
   2.06289425e+08 +3.21375110e+04j, -7.68188082e+05 +2.78241688e+06j,
   3.90286394e+09 -5.52324412e+05j,  3.44468670e+06 -1.47560697e+07j,
   5.92398609e+09 -2.36650242e+05j, -1.19629709e+06 +9.37996397e+06j,
   1.25154669e+09 +0.00000000e+00j, -5.33349070e+05 -2.88899295e+06j,
  -2.19326584e+09 +4.42493988e+05j,  6.78544395e+05 -1.08246425e+06j,
  -2.36981169e+08 -7.29511238e+04j,  1.15698511e+06 +9.44206397e+05j,
   2.99189941e+09 -2.08278154e+06j, -1.14685357e+06 +6.74929432e+05j,
   3.68615478e+09 +1.22088224e+06j]))
a4 = a.healpix.Alm(8,8)
a4.set_data(n.array(
[ -7.25013479e+08 +0.00000000e+00j, -2.23405382e+08 +0.00000000e+00j,
  -2.08999389e+05 -1.55521135e+06j,  1.63022821e+09 +0.00000000e+00j,
  -4.84213816e+05 +4.07460675e+06j, -1.71485236e+09 -3.56922108e+05j,
   5.35774915e+07 +0.00000000e+00j,  2.15431415e+05 +2.92914982e+06j,
  -1.64639859e+09 -3.92318700e+03j, -1.43321653e+05 +5.89648070e+05j,
  -6.97698736e+08 +0.00000000e+00j,  4.13734366e+05 +1.99187440e+06j,
  -7.24939465e+07 +1.64501666e+03j, -4.83689759e+05 +1.72520080e+06j,
  -1.85906425e+08 +8.40336657e+04j,  4.12354841e+08 +0.00000000e+00j,
   1.88103567e+05 -1.02110693e+06j, -9.04862739e+08 +4.73641082e+04j,
   2.37028140e+05 -1.01019460e+06j,  1.32638472e+09 +3.16687343e+04j,
  -8.68210687e+05 +1.46429372e+05j,  3.35047548e+08 +0.00000000e+00j,
   2.12104782e+03 +3.03150891e+04j,  4.52432398e+08 +9.78027545e+04j,
   3.66371745e+05 -2.84873058e+06j,  3.53915766e+08 -2.61165984e+05j,
  -1.06851237e+06 -7.63511945e+05j, -3.10134064e+09 -3.19944904e+05j,
   1.05799570e+09 +0.00000000e+00j, -4.96481411e+05 +1.64452797e+06j,
  -5.88583053e+07 -7.79074291e+03j,  1.82590335e+05 -6.47058752e+05j,
  -9.28986179e+08 +1.37323964e+05j, -8.22538406e+05 +3.45579805e+06j,
  -1.40654797e+09 +5.80422990e+04j,  2.80193319e+05 -2.27511525e+06j,
  -3.04624302e+08 +0.00000000e+00j,  1.32752153e+05 +6.75927456e+05j,
   5.27584941e+08 -1.06746085e+05j, -1.67262331e+05 +2.71801062e+05j,
   6.02259330e+07 +1.61249887e+04j, -2.76029054e+05 -2.10064334e+05j,
  -7.21399991e+08 +4.98854895e+05j,  2.67660135e+05 -9.25612753e+04j,
  -8.94944754e+08 -2.91677474e+05j]))
a3 = a.healpix.Alm(8,8)
a3.set_data(n.array(
[  1.02390768e+08 +0.00000000e+00j,  2.85186640e+07 +0.00000000e+00j,
   3.21178788e+04 +2.63249914e+05j, -2.33806440e+08 +0.00000000e+00j,
   7.06856032e+04 -5.41407430e+05j,  2.44007309e+08 +5.11100856e+04j,
   3.93857329e+06 +0.00000000e+00j, -3.31182187e+04 -3.92974192e+05j,
   2.30492156e+08 +3.20599589e+02j,  2.04585954e+04 -8.42494781e+04j,
   1.07026152e+08 +0.00000000e+00j, -6.01709437e+04 -2.73819893e+05j,
   1.68241451e+07 -3.51359760e+02j,  6.96949259e+04 -2.48920961e+05j,
   2.08196425e+07 -1.15303010e+04j, -5.57537972e+07 +0.00000000e+00j,
  -2.77318165e+04 +1.53270950e+05j,  1.33862057e+08 -7.06862508e+03j,
  -3.40056962e+04 +1.38990553e+05j, -1.94583801e+08 -4.22792833e+03j,
   1.25634947e+05 -1.78009169e+04j, -4.74570753e+07 +0.00000000e+00j,
  -1.93582203e+02 +2.52721808e+03j, -6.43693042e+07 -1.38745917e+04j,
  -5.03842067e+04 +4.02172660e+05j, -4.90014212e+07 +3.76379365e+04j,
   1.52358675e+05 +1.07511934e+05j,  4.45552690e+08 +4.55121121e+04j,
  -1.51885715e+08 +0.00000000e+00j,  7.11123925e+04 -2.28219380e+05j,
   9.77260225e+06 +1.13570784e+03j, -2.59452598e+04 +8.99856618e+04j,
   1.31969776e+08 -2.03606644e+04j,  1.17273237e+05 -4.83340518e+05j,
   1.99288803e+08 -8.48899504e+03j, -3.91483596e+04 +3.29011530e+05j,
   4.42482044e+07 +0.00000000e+00j, -1.97062774e+04 -9.44808573e+04j,
  -7.57724862e+07 +1.53917217e+04j,  2.46057559e+04 -4.06668492e+04j,
  -9.05755454e+06 -2.12417217e+03j,  3.93103477e+04 +2.77085606e+04j,
   1.03867161e+08 -7.13492954e+04j, -3.72900776e+04 +3.86643336e+03j,
   1.29692751e+08 +4.16084978e+04j]))
a2 = a.healpix.Alm(8,8)
a2.set_data(n.array(
[ -8.59623515e+06 +0.00000000e+00j, -2.15201575e+06 +0.00000000e+00j,
  -2.93417106e+03 -2.58077641e+04j,  1.99797474e+07 +0.00000000e+00j,
  -6.15394989e+03 +4.28729407e+04j, -2.07277191e+07 -4.36853761e+03j,
  -1.34282958e+06 +0.00000000e+00j,  3.02589789e+03 +3.14686020e+04j,
  -1.92478830e+07 -5.07837785e+00j, -1.74110119e+03 +7.18783772e+03j,
  -9.75921705e+06 +0.00000000e+00j,  5.21799228e+03 +2.25093241e+04j,
  -1.99350115e+06 +3.93310294e+01j, -5.99194537e+03 +2.14395875e+04j,
  -1.28817724e+06 +9.43763514e+02j,  4.47818828e+06 +0.00000000e+00j,
   2.43518580e+03 -1.36668053e+04j, -1.18095214e+07 +6.28362916e+02j,
   2.91177885e+03 -1.14303250e+04j,  1.70212899e+07 +3.35756614e+02j,
  -1.08503530e+04 +1.28067896e+03j,  4.00695141e+06 +0.00000000e+00j,
   5.37923103e+00 -7.68223084e+02j,  5.46310111e+06 +1.17624014e+03j,
   4.13129245e+03 -3.39103730e+04j,  4.03761069e+06 -3.23807435e+03j,
  -1.29683140e+04 -9.03975180e+03j, -3.81991771e+07 -3.86655058e+03j,
   1.30172058e+07 +0.00000000e+00j, -6.08160805e+03 +1.89214513e+04j,
  -9.49829798e+05 -9.94449138e+01j,  2.20393626e+03 -7.48496675e+03j,
  -1.11880212e+07 +1.79999573e+03j, -9.98291522e+03 +4.03739120e+04j,
  -1.68495932e+07 +7.40352820e+02j,  3.26296520e+03 -2.83701275e+04j,
  -3.83574060e+06 +0.00000000e+00j,  1.74424730e+03 +7.89041985e+03j,
   6.49709476e+06 -1.32631551e+03j, -2.15982705e+03 +3.62547271e+03j,
   8.06665305e+05 +1.66820772e+02j, -3.34170250e+03 -2.16503073e+03j,
  -8.92923033e+06 +6.09356899e+03j,  3.10141256e+03 +4.25662518e+02j,
  -1.12171649e+07 -3.54393704e+03j]))
a1 = a.healpix.Alm(8,8)
a1.set_data(n.array(
[  3.97121866e+05 +0.00000000e+00j,  8.87953995e+04 +0.00000000e+00j,
   1.47580850e+02 +1.36829846e+03j, -9.41821914e+05 +0.00000000e+00j,
   2.95841157e+02 -1.87322391e+03j,  9.73267265e+05 +2.06358915e+02j,
   1.11399672e+05 +0.00000000e+00j, -1.52166255e+02 -1.39278496e+03j,
   8.87773259e+05 -8.89394578e-01j,  8.18010795e+01 -3.39035646e+02j,
   4.89888480e+05 +0.00000000e+00j, -2.49824420e+02 -1.02463216e+03j,
   1.20477605e+05 -2.26890146e+00j,  2.84603444e+02 -1.02065049e+03j,
   3.79434783e+04 -4.26737351e+01j, -1.97768966e+05 +0.00000000e+00j,
  -1.17944875e+02 +6.70749107e+02j,  5.75227028e+05 -3.08063044e+01j,
  -1.37761135e+02 +5.20254662e+02j, -8.21989111e+05 -1.46830464e+01j,
   5.17808262e+02 -5.03977557e+01j, -1.86710881e+05 +0.00000000e+00j,
   3.53037131e-01 +6.07623682e+01j, -2.56087241e+05 -5.51774072e+01j,
  -1.87025131e+02 +1.58125723e+03j, -1.83303579e+05 +1.53968397e+02j,
   6.10080534e+02 +4.20314894e+02j,  1.80956057e+06 +1.81649214e+02j,
  -6.16658253e+05 +0.00000000e+00j,  2.87531322e+02 -8.67846375e+02j,
   5.02310654e+04 +4.83681834e+00j, -1.03621383e+02 +3.44853275e+02j,
   5.24091487e+05 -8.78442841e+01j,  4.69778938e+02 -1.86502496e+03j,
   7.87138639e+05 -3.56513412e+01j, -1.50227391e+02 +1.35074796e+03j,
   1.83740583e+05 +0.00000000e+00j, -8.52227508e+01 -3.64557574e+02j,
  -3.07938728e+05 +6.32314908e+01j,  1.04725613e+02 -1.78318435e+02j,
  -3.94167205e+04 -7.23532779e+00j,  1.57000319e+02 +9.26838122e+01j,
   4.24348574e+05 -2.87729723e+02j, -1.42590845e+02 -5.36692275e+01j,
   5.36087376e+05 +1.66866449e+02j]))
a0 = a.healpix.Alm(8,8)
a0.set_data(n.array(
[ -7.78255067e+03 +0.j        , -1.54157922e+03 +0.j        ,
  -3.15320929e+00-30.42966091j,  1.88919873e+04 +0.j        ,
  -6.05799707e+00+34.83202299j, -1.94862026e+04 -4.15584361j,
  -3.21330250e+03 +0.j        ,  3.24947272e+00+26.28470255j,
  -1.74474994e+04 +0.04201184j, -1.63682741e+00 +6.81998694j,
  -1.04450549e+04 +0.j        ,  5.09416249e+00+19.92547509j,
  -2.95422004e+03 +0.05341916j, -5.76129217e+00+20.71772187j,
  -3.10737006e+02 +0.82242113j,  3.70307356e+03 +0.j        ,
   2.43084768e+00-13.98544632j, -1.19329092e+04 +0.64255785j,
   2.77781233e+00-10.1101813j ,  1.69043566e+04 +0.27270619j,
  -1.05332013e+01 +0.83486813j,  3.70366913e+03 +0.j        ,
  -2.08442513e-02 -1.68505962j,  5.11458262e+03 +1.10487857j,
   3.60634953e+00-31.45801623j,  3.53671075e+03 -3.12118806j,
  -1.22367329e+01 -8.33823209j, -3.65379911e+04 -3.64037924j,
   1.24560850e+04 +0.j        , -5.79734519e+00+16.98754861j,
  -1.11804303e+03 -0.10068849j,  2.07999967e+00 -6.78970614j,
  -1.04647377e+04 +1.82545716j, -9.42746575e+00+36.75518944j,
  -1.56737797e+04 +0.73126776j,  2.94747871e+00-27.3964777j ,
  -3.75194501e+03 +0.j        ,  1.77291588e+00 +7.188803j  ,
   6.22326075e+03 -1.28636572j, -2.16358736e+00 +3.73282778j,
   8.15698746e+02 +0.13374158j, -3.14478965e+00 -1.67464225j,
  -8.59938680e+03 +5.79452877j,  2.79592478e+00 +1.71434465j,
  -1.09205152e+04 -3.35049431j]))

coeffs = {7:a7.get_data(), 6:a6.get_data(), 5:a5.get_data(), 4:a4.get_data(),
    3:a3.get_data(), 2:a2.get_data(), 1:a1.get_data(), 0:a0.get_data()}
b = a.sim.BeamAlm(freqs, coeffs=coeffs)

print b.response((0,0,1))
print b.response((x,y,z))
