import al_papi

class Locales(object):
  """
    Locales class is used as a helper class to find out the supported locales
    for the search engine you are passing to the API::
    
        al_papi.Locales.supported(<engine>)
    
    By default engine is google. The supported engines are currently google, yahoo and bing. You can
    optionally call direct engine methods to return the supported locales::
    
      al_papi.Locales.google()
      al_papi.Locales.yahoo()
      al_papi.Locales.bing()
  """
  
  @staticmethod
  def google():
    return [
      'af-za',
      'ar-ae',
      'ar-bh',
      'ar-il',
      'ar-qa',
      'ar-sa',
      'ar-tn',
      'bg-bg',
      'ca-ct',
      'cs-cz',
      'da-dk',
      'de-at',
      'de-be',
      'de-ch',
      'de-de',
      'de-ro',
      'el-gr',
      'en-ae',
      'en-au',
      'en-be',
      'en-bh',
      'en-ca',
      'en-hk',
      'en-id',
      'en-ie',
      'en-il',
      'en-in',
      'en-mt',
      'en-my',
      'en-ng',
      'en-nz',
      'en-ph',
      'en-sa',
      'en-sg',
      'en-th',
      'en-tw',
      'en-ua',
      'en-uk',
      'en-us',
      'en-vn',
      'en-qa',
      'en-za',
      'es-ar',
      'es-cl',
      'es-co',
      'es-es',
      'es-mx',
      'es-pe',
      'es-pr',
      'es-us',
      'es-ve',
      'et-ee',
      'fi-fl',
      'fr-be',
      'fr-ca',
      'fr-ch',
      'fr-fr',
      'fr-tn',
      'fr-vn',
      'ga-ie',
      'ha-ng',
      'he-il',
      'hi-in',
      'hr-hr',
      'hu-hu',
      'hu-ro',
      'id-id',
      'ie-en',
      'ig-ng',
      'it-ch',
      'it-it',
      'ja-jp',
      'jw-id',
      'ko-kr',
      'lt-lt',
      'lt-lv',
      'lv-lv',
      'mi-nz',
      'ms-my',
      'ms-sg',
      'mt-mt',
      'nl-be',
      'nl-nl',
      'no-no',
      'pl-pl',
      'pt-br',
      'pt-pt',
      'rm-ch',
      'ro-ro',
      'ru-et',
      'ru-lv',
      'ru-ru',
      'ru-ua',
      'sl-si',
      'sk-sk',
      'sr-rs',
      'sv-fi',
      'sv-se',
      'ta-sg',
      'th-th',
      'tl-ph',
      'tr-tr',
      'uk-ua',
      'vi-vn',
      'xh-za',
      'yo-ng',
      'zh-cn-hk',
      'zh-hk-hk',
      'zh-cn-sg',
      'zh-cn-tw',
      'zh-cn-vn',
      'zh-tw-tw',
      'zu-za'
    ]
    
  
  @staticmethod
  def yahoo():
    return [
      'da-dk',
      'de-at',
      'de-ch',
      'de-de',
      'el-gr',
      'en-au',
      'en-ca',
      'en-ie',
      'en-in',
      'en-my',
      'en-nz',
      'en-ph',
      'en-sg',
      'en-tw',
      'en-uk',
      'en-us',
      'es-ar',
      'es-cl',
      'es-co',
      'es-es',
      'es-mx',
      'es-pe',
      'es-us',
      'es-ve',
      'fi-fl',
      'fr-ca',
      'fr-ch',
      'fr-fr',
      'id-id',
      'it-ch',
      'it-it',
      'ja-jp',
      'ko-kr',
      'kr-kr',
      'nl-nl',
      'no-no',
      'pt-br',
      'ro-ro',
      'ru-ru',
      'sv-se',
      'th-th',
      'tr-tr',
      'vi-vn',
      'zh-cn',
      'zh-cn-tw',
      'zh-hk'
    ]
  
  
  @staticmethod
  def bing():
    return [
      'ar-sa',
      'de-at',
      'de-ch',
      'de-de',
      'da-dk',
      'en-au',
      'en-ca',
      'en-ch',
      'en-ie',
      'en-in',
      'en-nz',
      'en-sa',
      'en-sg',
      'en-uk',
      'en-us',
      'es-ar',
      'es-co',
      'es-cl',
      'es-es',
      'es-mx',
      'es-pe',
      'es-us',
      'es-ve',
      'fr-ca',
      'fr-ch',
      'fr-fr',
      'it-ch',
      'it-it',
      'ja-jp',
      'ms-my',
      'nl-be',
      'nl-nl',
      'no-no',
      'pt-br',
      'rm-ch',
      'ru-ru',
      'sv-se',
      'tl-ph',
      'vi-vn',
      'zh-cn',
      'zh-cn-tw',
      'zh-hk'
    ]
  
  
  @staticmethod
  def supported(engine = "google"):
    locales_hash = { "google" : Locales.google(), "yahoo" : Locales.yahoo(), "bing" : Locales.bing() }
    return locales_hash[engine]
  