/*
  alignlib - a library for aligning protein sequences

  $Id$

  Copyright (C) 2004 Andreas Heger

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/** include file factory and helper functions
 */

#ifndef ALIGNLIB_FUNCTIONS_H_
#define ALIGNLIB_FUNCTIONS_H_

#include "AlignlibException.h"
#include "AlignlibMethods.h"

#include "HelpersAlignandum.h"
#include "HelpersAlignment.h"
#include "HelpersAlignator.h"
#include "HelpersAlignatum.h"
#include "HelpersFragmentor.h"
#include "HelpersIterator2D.h"
#include "HelpersLogOddor.h"
#include "HelpersMultipleAlignment.h"
#include "HelpersMultipleAlignator.h"
#include "HelpersMultAlignment.h"
#include "HelpersRegularizor.h"
#include "HelpersPalette.h"
#include "HelpersScorer.h"
#include "HelpersSubstitutionMatrix.h"
#include "HelpersEncoder.h"
#include "HelpersWeightor.h"
#include "HelpersDistor.h"
#include "HelpersTreetor.h"
#include "HelpersDistanceMatrix.h"
#include "HelpersTree.h"

#include "AlignmentFormat.h"
#include "MultipleAlignmentFormat.h"
#include "MultAlignmentFormat.h"
#include "Statistics.h"
#include "HelpersToolkit.h"

#endif /*ALIGNLIB_FUNCTIONS_H_*/
