#!/usr/bin/env python

# setuptools plugin for darcs
# Author: Zooko O'Whielacronx

# Permission is hereby granted to any person obtaining a copy of this work to
# deal in this work without restriction (including the rights to use, modify,
# distribute, sublicense, and/or sell copies).

# See README.txt for instructions.

# Thanks to the authors of setuptools, setuptools_bzr, setuptools_git, and
# setuptools_mtn for documentation and examples.

import os, re

miscdeps=os.path.join('misc', 'dependencies')

try:
    from ez_setup import use_setuptools
except ImportError:
    pass
else:
    import sys
    if 'cygwin' in sys.platform.lower():
        min_version='0.6c6'
    else:
        min_version='0.6a9'
    download_base = "file:"+miscdeps+os.path.sep
    use_setuptools(min_version=min_version, download_delay=0, download_base=download_base, to_dir=miscdeps)

from setuptools import setup, find_packages

trove_classifiers=[
    "Development Status :: 5 - Production/Stable",
    "License :: OSI Approved :: BSD License",
    "License :: DFSG approved",
    "Intended Audience :: Developers", 
    "Operating System :: Microsoft",
    "Operating System :: Microsoft :: Windows",
    "Operating System :: Unix",
    "Operating System :: POSIX :: Linux",
    "Operating System :: POSIX",
    "Operating System :: MacOS :: MacOS X",
    "Operating System :: Microsoft :: Windows :: Windows NT/2000",
    "Operating System :: OS Independent", 
    "Natural Language :: English", 
    "Programming Language :: Python", 
    "Topic :: Utilities",
    "Topic :: Software Development :: Libraries",
    ]

try:
    (cin, cout, cerr,) = os.popen3("darcsver --quiet")
    print cout.read()
except Exception, le:
    pass
VERSIONFILE = "setuptools_darcs/_version.py"
verstr = "unknown"
VSRE = re.compile("^verstr = ['\"]([^'\"]*)['\"]", re.M)
try:
    verstrline = open(VERSIONFILE, "rt").read()
except EnvironmentError:
    pass # Okay, there is no version file.
else:
    mo = VSRE.search(verstrline)
    if mo:
        verstr = mo.group(1)
    else:
        print "unable to find version in %s" % (VERSIONFILE,)
        raise RuntimeError("If %s.py exists, it is required to be well-formed." % (VERSIONFILE,))

setup(
    name            = 'setuptools_darcs',
    version         = verstr,
    description     = 'setuptools plugin for darcs',
    author          = "Zooko O'Whielacronx",
    author_email    = 'zooko@zooko.com',
    url             = 'http://pypi.python.org/pypi/setuptools_darcs',
    classifiers     = trove_classifiers,
    license         = 'BSD',
    zip_safe        = False, # I prefer unzipped for easier access.
    packages        = find_packages(),
    include_package_data=True,
    keywords        = 'distutils setuptools setup',
    entry_points    = {
        'setuptools.file_finders': [
            'darcs = setuptools_darcs.setuptools_darcs:find_files_for_darcs',
            ],
        },
    extras_require={'autoversioning':'pyutil >= 1.3.8'}, # for darcsver
    )
