#!/usr/bin/env python

# Copyright (c) 2002 Luke 'Artimage' Nelson
# Copyright (c) 2005 Bryce "Zooko" Wilcox-O'Hearn
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this work to deal in this work without restriction (including the rights
# to use, modify, distribute, sublicense, and/or sell copies).

import tempfile, unittest, os

try:
    from twisted.trial import unittest
except ImportError, le:
    print "Skipping %s since it requires Twisted and Twisted could not be imported: %s" % (__name__, le,)
else:
    from pyutil import PickleSaver, fileutil

    class Thingie(PickleSaver.PickleSaver):
        def __init__(self, fname, delay=30):
            PickleSaver.PickleSaver.__init__(self, fname=fname, attrs={'tmp_store':'False'}, DELAY=delay)

    class PickleSaverTest(unittest.TestCase):
        def _test_save_now(self, fname):
            thingie = Thingie(fname, delay=0)
            thingie.tmp_store = 'True'
            thingie.lazy_save() # Note: it was constructed with default save delay of 0.

        def test_save_now(self):
            """
            This test should create a lazy save object, save it with no delay and check if the file exists.
            """
            tempdir = fileutil.NamedTemporaryDirectory()

            fname = os.path.join(tempdir.name, "picklesavertest")
            self._test_save_now(fname)
            self.failUnless(os.path.isfile(fname), "The file [%s] does not exist." %(fname,))

            tempdir.shutdown()
