#!/usr/bin/env python

# pyutil -- utility functions and classes
# 
# Author: Zooko Wilcox-O'Hearn
# 
# This file is part of pyutil.
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by the
# Free Software Foundation; either version 2.1 of the License, or (at your
# option) any later version, with the added permission that, if you become
# obligated to release a derived work under this licence (as per section 2.c),
# you may delay the fulfillment of this obligation for up to 12 months.  If
# you are obligated to release code under section 2.c of this licence, you are
# obligated to release it under these same terms, including the 12-month grace
# period clause.  See the COPYING file for details.

import os, re

miscdeps=os.path.join('misc', 'dependencies')

try:
    from ez_setup import use_setuptools
except ImportError:
    pass
else:
    import sys
    if 'cygwin' in sys.platform.lower():
        min_version='0.6c6'
    else:
        min_version='0.6a9'
    download_base = "file:"+miscdeps+os.path.sep
    use_setuptools(min_version=min_version, download_delay=0, download_base=download_base, to_dir=miscdeps)

from setuptools import Extension, find_packages, setup

trove_classifiers=[
    "Development Status :: 5 - Production/Stable",
    "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)",
    "License :: DFSG approved",
    "Intended Audience :: Developers", 
    "Operating System :: Microsoft",
    "Operating System :: Microsoft :: Windows",
    "Operating System :: Unix",
    "Operating System :: POSIX :: Linux",
    "Operating System :: POSIX",
    "Operating System :: MacOS :: MacOS X",
    "Operating System :: Microsoft :: Windows :: Windows NT/2000",
    "Operating System :: OS Independent", 
    "Natural Language :: English", 
    "Programming Language :: Python", 
    "Topic :: Utilities",
    "Topic :: Software Development :: Libraries",
    ]

try:
    import os
    (cin, cout, cerr,) = os.popen3("darcsver")
    print cout.read()
except Exception, le:
    pass
VERSIONFILE = "pyutil/_version.py"
verstr = "unknown"
VSRE = re.compile("^verstr = ['\"]([^'\"]*)['\"]", re.M)
try:
    verstrline = open(VERSIONFILE, "rt").read()
except EnvironmentError:
    pass # Okay, there is no version file.
else:
    mo = VSRE.search(verstrline)
    if mo:
        verstr = mo.group(1)
    else:
        print "unable to find version in %s" % (VERSIONFILE,)
        raise RuntimeError("if %s.py exists, it must be well-formed" % (VERSIONFILE,))

dependency_links=[os.path.join(miscdeps, t) for t in os.listdir(miscdeps) if t.endswith(".tar")]

setup(name='pyutil',
      version=verstr,
      description='a collection of mature utilities for Python programmers',
      long_description="These are a few data structures, classes and functions which we've needed over many years of Python programming and which seem to be of general use to other Python programmers.  Many of the modules that have existed in pyutil over the years have subsequently been obsoleted by new features added to the Python language or its standard library, thus showing that we're not alone in wanting tools like these.",
      author='Zooko O\'Whielacronx',
      author_email='zooko@zooko.com',
      url='http://zooko.com/repos/pyutil',
      license='GNU LGPL',
      packages=find_packages(),
      include_package_data=True,
      dependency_links=dependency_links,
      setup_requires=['setuptools_darcs >= 1.0.5',],
      classifiers=trove_classifiers,
      entry_points = { 'console_scripts': [ 'darcsver = scripts.darcsver:main', 'sha1sum = scripts.sha1sum:main', 'randcookie = scripts.randcookie:main', 'adler32sum = scripts.adler32sum:main', 'sha256sum = scripts.sha256sum:main', 'tailx = scripts.tailx:main', 'lines = scripts.lines:main', 'randfile = scripts.randfile:main' ] },
      ext_modules=[Extension('pyutil.xor.c_xor', ['pyutil/xor/xormodule.c',]),],
      test_suite="pyutil.test",
      install_requires=["argparse >= 0.8",],
      zip_safe=False, # I prefer unzipped for easier access.
      )
