import os, string, sys, re
import xml.dom.minidom
from subprocess import Popen, PIPE

try:
    # If we can import pyutil.version_class then use its regex.
    from pyutil import version_class
    VERSION_BASE_RE_STR = version_class.VERSION_BASE_RE_STR
except ImportError:
    # Else (perhaps a bootstrapping problem),then we'll use this
    # regex, which was copied from the pyutil source code on
    # 2007-10-30.
    VERSION_BASE_RE_STR="(\d+)(\.(\d+)(\.(\d+))?)?((a|b|c)(\d+))?"

def get_text(nodelist):
    rc = ""
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc = rc + node.data
    return rc

VERSION_BODY = '''
# This is the version of this tree, as created by %s from the Darcs patch
# information: the main version number is taken from the most recent release
# tag. If some patches have been added since the last release, this will have a
# -NN "build number" suffix, or else a -rNN "revision number" suffix. Please see
# pyutil.version_class for a description of what the different fields mean.

verstr = "%s"
try:
    from pyutil.version_class import Version as pyutil_Version
    __version__ = pyutil_Version(verstr)
except (ImportError, ValueError):
    # Maybe there is no pyutil installed, or this may be an older version of 
    # pyutil.version_class which doesn't support SVN-alike revision numbers.
    from distutils.version import LooseVersion as distutils_Version
    __version__ = distutils_Version(verstr)
'''

def write_version_py(verstr, outfname, EXE_NAME):
    f = open(outfname, "wt+")
    f.write(VERSION_BODY % (EXE_NAME, verstr,))
    f.close()

def update(pkgname, verfilename, revision_number=False, quiet=False, EXE_NAME="darcsver"):
    """
    @param revision_number If true, count the total number of patches in all
    history.  If false, count the total number of patches since the most recent
    release tag.
    """
    rc = -1
    cmd = ["changes", "--xml-output"]
    if not revision_number:
        cmd.append("--from-tag=^%s" % (pkgname,))

    try:
        p = Popen(["darcs"] + cmd, stdout=PIPE, universal_newlines=True)
    except:
        pass
    else:
        output = p.communicate()[0]
        rc = p.returncode
    if rc != 0:
        p = Popen(["realdarcs.exe"] + cmd, stdout=PIPE, universal_newlines=True)
        output = p.communicate()[0]
        rc = p.returncode
        if rc != 0:
            if os.path.exists(verfilename):
                if not quiet:
                    print "%s: Failure from attempt to find version tags with 'darcs changes', and %s already exists, so leaving it alone." % (EXE_NAME, verfilename,)
                return 0
            else:
                if not quiet:
                    print "%s: Failure from attempt to find version tags with 'darcs changes', and %s doesn't exist." % (EXE_NAME, verfilename,)
                return rc

    # Filter out bad chars that can cause the XML parser to give up in despair.
    # (Thanks to lelit of the tailor project for this hack.)
    allbadchars = "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0B\x0C\x0E\x0F\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1A\x1B\x1C\x1D\x1E\x1F\x7f"
    tt = string.maketrans(allbadchars, "?"*len(allbadchars))
    output = output.translate(tt)

    doc = xml.dom.minidom.parseString(output)
    changelog = doc.getElementsByTagName("changelog")[0]
    patches = changelog.getElementsByTagName("patch")
    regexstr = "^TAG %s-(%s)" % (pkgname, VERSION_BASE_RE_STR,)
    version_re = re.compile(regexstr)
    last_tag = None
    count_since_last_patch = 0
    for patch in patches:
        name = get_text(patch.getElementsByTagName("name")[0].childNodes)
        m = version_re.match(name)
        if m:
            last_tag = m.group(1)
            last_tag = last_tag.encode("utf-8")
            break
        else:
            count_since_last_patch += 1

    if not last_tag:
        if not quiet:
            print "%s: I'm unable to find a tag in the darcs history matching \"%s\", so I'm leaving %s alone." % (EXE_NAME, regexstr, verfilename,)
        return 0

    if revision_number:
        if count_since_last_patch:
            # this is an interim version
            verstr = "%s-r%d" % (last_tag, len(patches))
        else:
            # this is a release
            verstr = last_tag
    else:
        if count_since_last_patch:
            # this is an interim version
            verstr = "%s-%d" % (last_tag, count_since_last_patch)
        else:
            # this is a release
            verstr = last_tag

    write_version_py(verstr, verfilename, EXE_NAME)
    if not quiet:
        print "%s: wrote '%s' into %s" % (EXE_NAME, verstr, verfilename,)
    return 0
