#! /usr/bin/env python

import os, sys

from darcsver import darcsvermodule

try:
    EXE_NAME=os.path.basename(sys.argv[0])
except:
    EXE_NAME="darcsver"

def main():
    quiet = False
    if "--version" in sys.argv:
        print "%s version %s" % (EXE_NAME, darcsver.__version__,)
        sys.exit(0)

    if "--quiet" in sys.argv:
        quiet = True
        sys.argv.remove("--quiet")
    if "-q" in sys.argv:
        quiet = True
        sys.argv.remove("-q")
        
    count_all_patches=False
    if "--count-all-patches" in sys.argv:
        count_all_patches=True
        sys.argv.remove("--count-all-patches")

    if len(sys.argv) >= 2:
        pkgname = sys.argv[1]
    else:
        pkgname = os.path.basename(os.getcwd())
        if not quiet:
            print "%s: You didn't pass a pkg-name on the command-line, so I'm going to take the name of the current working directory: \"%s\"" % (EXE_NAME, pkgname,)

    if len(sys.argv) >= 3:
        verfilename = sys.argv[2]
    else:
        verfilename = os.path.join(pkgname, "_version.py")
        if not quiet:
            print "%s: You didn't pass a verfilename on the command-line, so I'm going to build one from the name of the package: \"%s\"" % (EXE_NAME, verfilename,)

    rc = darcsvermodule.update(pkgname=pkgname, verfilename=verfilename, count_all_patches=count_all_patches, quiet=quiet, EXE_NAME=EXE_NAME)
    return rc

if __name__ == "__main__":
    rc = main()
    sys.exit(rc)
