#!/usr/bin/env python

# pyutil -- utility functions and classes
# 
# Author: Zooko Wilcox-O'Hearn
# 
# See README.txt for licensing information.

import os, re, sys

try:
    from ez_setup import use_setuptools
except ImportError:
    pass
else:
    # On cygwin there was a permissions error that was fixed in 0.6c6.
    use_setuptools(min_version='0.6c6', download_delay=0)

from setuptools import Extension, find_packages, setup

trove_classifiers=[
    "Development Status :: 5 - Production/Stable",
    "License :: OSI Approved :: GNU General Public License (GPL)", 
    "License :: DFSG approved",
    "License :: Other/Proprietary License",
    "Intended Audience :: Developers", 
    "Operating System :: Microsoft",
    "Operating System :: Microsoft :: Windows",
    "Operating System :: Unix",
    "Operating System :: POSIX :: Linux",
    "Operating System :: POSIX",
    "Operating System :: MacOS :: MacOS X",
    "Operating System :: Microsoft :: Windows :: Windows NT/2000",
    "Operating System :: OS Independent", 
    "Natural Language :: English", 
    "Programming Language :: Python", 
    "Topic :: Utilities",
    "Topic :: Software Development :: Libraries",
    ]

VERSIONFILE = "pyutil/_version.py"
verstr = "unknown"
try:
    verstrline = open(VERSIONFILE, "rt").read()
except EnvironmentError:
    pass # Okay, there is no version file.
else:
    VSRE = r"^verstr = ['\"]([^'\"]*)['\"]"
    mo = re.search(VSRE, verstrline, re.M)
    if mo:
        verstr = mo.group(1)
    else:
        print "unable to find version in %s" % (VERSIONFILE,)
        raise RuntimeError("if %s.py exists, it must be well-formed" % (VERSIONFILE,))

setup_requires = []

# darcsver is needed only if you want "./setup.py darcsver" to write a new
# version stamp in pyutil/_version.py, with a version number derived from
# darcs history.  http://pypi.python.org/pypi/darcsver
if 'darcsver' in sys.argv[1:]:
    setup_requires.append('darcsver >= 1.0.0')

# setuptools_darcs is required to produce complete distributions (such as with
# "sdist" or "bdist_egg"), unless there is a PKG-INFO file present which shows
# that this is itself a source distribution.
# http://pypi.python.org/pypi/setuptools_darcs
if not os.path.exists('PKG-INFO'):
    for arg in sys.argv[1:]:
        if 'dist' == arg[1:5]:
            setup_requires.append('setuptools_darcs >= 1.0.5')
            break

setup(name='pyutil',
      version=verstr,
      description='a collection of mature utilities for Python programmers',
      long_description="These are a few data structures, classes and functions which we've needed over many years of Python programming and which seem to be of general use to other Python programmers.  Many of the modules that have existed in pyutil over the years have subsequently been obsoleted by new features added to the Python language or its standard library, thus showing that we're not alone in wanting tools like these.",
      author='Zooko O\'Whielacronx',
      author_email='zooko@zooko.com',
      url='http://zooko.com/repos/pyutil',
      license='GNU GPL',
      packages=find_packages(),
      include_package_data=True,
      setup_requires=setup_requires,
      classifiers=trove_classifiers,
      entry_points = { 'console_scripts': [ 'sha256dcppsum = pyutil.scripts.sha256dcppsum:main', 'sha256dsum = pyutil.scripts.sha256dsum:main', 'sha1sum = pyutil.scripts.sha1sum:main', 'randcookie = pyutil.scripts.randcookie:main', 'adler32sum = pyutil.scripts.adler32sum:main', 'sha256sum = pyutil.scripts.sha256sum:main', 'tailx = pyutil.scripts.tailx:main', 'lines = pyutil.scripts.lines:main', 'randfile = pyutil.scripts.randfile:main', 'find_trial = pyutil.scripts.find_trial:main' ] },
      ext_modules=[Extension('pyutil.xor.c_xor', ['pyutil/xor/xormodule.c',]),],
      test_suite='pyutil.test',
      extras_require={
        'randfile-script': ['argparse >= 0.8',],
        },
      zip_safe=False, # I prefer unzipped for easier access.
      )
