import argparse
import sys
import os

from almost_empty import python, tex

__version__ = '0.1.2-beta'


def get_params():
	parser = argparse.ArgumentParser(description='Create AlmostEmpty projects.', usage='almost-empty [-h] [-v] <language> -n <name> [-d <parent directory>] [-g <git repository>]', add_help=False)
	required = parser.add_argument_group('required arguments')
	required.add_argument('language', nargs=1, help='Language of new project')
	required.add_argument('-n', '--name', dest='name', help='Name of project to create', required=True)
	optional = parser.add_argument_group('optional arguments')
	optional.add_argument('-d', '--dir', dest='parent', help='Parent directory to create project under (assumes working directory)', required=False)
	optional.add_argument('-g', '--git', dest='repo', help='Address of remote Git repository (assumes none)', required=False)
	system = parser.add_argument_group('information')
	system.add_argument('-h', '--help', action='help')
	system.add_argument('-v', '--version', action='version', version='AlmostEmpty v' + __version__)
	args = parser.parse_args()

	return args.language, args.name, args.parent, args.repo


def execute_from_command_line():
	language, name, parent, repo = get_params()
	if not parent:
		parent = os.getcwd()
	directory = os.path.join(parent, name)

	if os.path.exists(directory):
		print 'Cannot create project in directory: ' + str(directory) + '. Error: directory already exists.'
		sys.exit(-1)
	os.mkdir(directory)

	if language[0] == 'python':
		python.pure(name, directory, repo)
	elif language[0] == 'django':
		python.django(name, directory, repo)
	elif language[0] == 'tex':
		tex.pure(name, directory, repo)
	else:
		print 'Invalid language: ', language[0]
