"""Run workflow for TeX-based projects"""
from re import sub
from subprocess import call
import os
import urllib

from almost_empty.all import meta
from almost_empty.helper import get_readable_name, modify_file, store_gitignore


def git(directory, repo):
	"""Set up git repo, if provided

	Provide useful git hooks"""
	if repo:
		call(['git', 'init'], cwd=directory)

		git_hooks = os.path.join(directory, '.git', 'hooks')
		urllib.urlretrieve('https://raw.githubusercontent.com/TheKevJames/util/master/.gittemplates/hooks/post-commit', os.path.join(git_hooks, 'post-commit'))

		call(['git', 'add', '.'], cwd=directory)
		call(['git', 'commit', '-m', 'Auto-generated AlmostEmpty project', '-n'], cwd=directory)
		call(['git', 'remote', 'add', 'origin', repo], cwd=directory)
		call(['git', 'push', '-u', '--force', 'origin', 'master'], cwd=directory)


####################
# Workflow Runners #
####################
def pure(name, directory, repo):
	"""Run workflow for a TeX project"""
	readable_name = get_readable_name(name)

	modify_file(name + '.tex', directory, ['\\documentclass[a4paper,11pt]{article}', '\\usepackage[T1]{fontenc}', '\\usepackage[utf8]{inputenc}', '\\usepackage{lmodern}', '', '\\title{' + readable_name + '}', '\\author{@TheKevJames (auto-generated)}', '', '\\begin{document}', '', '\\maketitle', '\\tableofcontents', '', '\\begin{abstract}', '\\end{abstract}', '', '\\section{}', '', '\\end{document}'])
	modify_file('Makefile', directory, ['all:', '\tlatexmk *.tex && latexmk -c', '', 'clean:', '\tlatexmk -CA'])

	meta(readable_name, directory)
	modify_file('README.md', directory, ['Empty project auto-generated by [AlmostEmpty](https://github.com/TheKevJames/almost-empty)', ''])
	store_gitignore('TeX', directory)

	git(directory, repo)
