#!/usr/bin/env python
import io
import os
from pip.req import parse_requirements
import re
from setuptools import find_packages, setup
from setuptools.command.test import test as TestCommand
import sys


def read(*filenames, **kwargs):
    encoding = kwargs.get('encoding', 'utf-8')
    sep = kwargs.get('sep', '\n')
    buf = []
    for filename in filenames:
        with io.open(filename, encoding=encoding) as f:
            buf.append(f.read())
    return sep.join(buf)

def find_version(*file_paths):
    version_file = read(os.path.join(*file_paths))
    version_match = re.search(
        r"^__version__ = ['\"]([^'\"]*)['\"]",
        version_file,
        re.M
    )
    if version_match:
        return version_match.group(1)
    raise RuntimeError('Unable to find version string.')

long_description = read('README.rst')
requires = [str(ir.req) for ir in parse_requirements('requirements/prod.txt')]

class PyTest(TestCommand):
    def __init__(self):
        self.test_args = []
        self.test_suite = True

        TestCommand.__init__()

    def finalize_options(self):
        TestCommand.finalize_options(self)

    def run_tests(self):
        import pytest

        errcode = pytest.main(self.test_args)
        sys.exit(errcode)

setup(
    name='almost-empty',
    version=find_version('almost_empty', '__init__.py'),
    description='Create AlmostEmpty packages',
    long_description=long_description,
    keywords='almost_empty empty barebones wireframe project',
    author='Kevin James',
    author_email='KevinJames@thekev.in',
    url='https://github.com/TheKevJames/almost-empty.git',
    license='MIT License',
    packages=find_packages(exclude=['test']),
    include_package_data=True,
    entry_points={'console_scripts': [
        'almost-empty = almost_empty:execute_from_command_line',
    ]},
    install_requires=requires,
    tests_require=['pytest'],
    zip_safe=False,
    classifiers=[
        'Programming Language :: Python',
        'Development Status :: 4 - Beta',
        'Natural Language :: English',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Topic :: Software Development',
    ],
    test_suite='test',
    extras_require={
        'testing': ['pytest'],
    },
)
